/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outer_end.registry;

import blueduck.outer_end.TheOuterEnd;
import blueduck.outer_end.block.AzureBerryVineBlock;
import blueduck.outer_end.block.AzureBerryVineTop;
import blueduck.outer_end.block.AzureGrassBlock;
import blueduck.outer_end.block.BrineBlock;
import blueduck.outer_end.block.EndSaplingBlock;
import blueduck.outer_end.block.EnderDoublePlant;
import blueduck.outer_end.block.EnderTallGrassBlock;
import blueduck.outer_end.block.MiasmaBlock;
import blueduck.outer_end.block.TangledVioliteBlock;
import blueduck.outer_end.feature.helpers.AzureTreeGrower;
import blueduck.outer_end.registry.OuterEndItems;
import blueduck.outer_end.registry.OuterEndSounds;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.LogBlock;
import com.teamabnormals.blueprint.common.block.WoodBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintCeilingHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.common.item.FuelBlockItem;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class OuterEndBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"outer_end");
    public static BlockSubRegistryHelper HELPER = (BlockSubRegistryHelper)TheOuterEnd.HELPER.getSubHelper(ForgeRegistries.BLOCKS);
    public static final RegistryObject<Block> AZURE_STEM = OuterEndBlocks.registerBlock("azure_stem", () -> new LogBlock(() -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("outer_end", "azure_stripped_stem")), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> STRIPPED_AZURE_STEM = OuterEndBlocks.registerBlock("azure_stripped_stem", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> AZURE_PITH = OuterEndBlocks.registerBlock("azure_pith", () -> new WoodBlock(() -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("outer_end", "azure_stripped_stem")), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> STRIPPED_AZURE_PITH = OuterEndBlocks.registerBlock("azure_stripped_pith", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> AZURE_PLANKS = OuterEndBlocks.registerBlock("azure_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> AZURE_SLAB = OuterEndBlocks.registerBlock("azure_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> AZURE_STAIRS = OuterEndBlocks.registerBlock("azure_stairs", () -> new StairBlock(() -> ((Block)AZURE_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    public static final RegistryObject<Block> AZURE_DOOR = OuterEndBlocks.registerBlock("azure_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_(), BlockSetType.f_271383_));
    public static final RegistryObject<Block> AZURE_TRAPDOOR = OuterEndBlocks.registerBlock("azure_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_(), BlockSetType.f_271383_));
    public static final RegistryObject<Block> AZURE_FENCE = OuterEndBlocks.registerBlock("azure_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> AZURE_FENCE_GATE = OuterEndBlocks.registerBlock("azure_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), WoodType.f_223002_));
    public static final RegistryObject<Block> AZURE_BUTTON = OuterEndBlocks.registerBlock("azure_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BlockSetType.f_271383_, 30, true));
    public static final RegistryObject<Block> AZURE_PRESSURE_PLATE = OuterEndBlocks.registerBlock("azure_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271383_));
    public static final Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> AZURE_SIGNS = HELPER.createSignBlock("azure", WoodType.f_61830_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_));
    public static final Pair<RegistryObject<BlueprintCeilingHangingSignBlock>, RegistryObject<BlueprintWallHangingSignBlock>> AZURE_HANGING_SIGNS = HELPER.createHangingSignBlock("azure", WoodType.f_61830_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_));
    public static final RegistryObject<Block> AZURE_LADDER = OuterEndBlocks.registerQuarkBlock("azure_ladder", () -> new LadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)));
    public static final RegistryObject<Block> AZURE_BOOKSHELF = OuterEndBlocks.registerQuarkBlock("azure_bookshelf", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)));
    public static final RegistryObject<Block> AZURE_CHEST = OuterEndBlocks.registerQuarkChest("azure", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_), false);
    public static final RegistryObject<Block> AZURE_TRAPPED_CHEST = OuterEndBlocks.registerQuarkChest("azure", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50325_), true);
    public static final RegistryObject<Block> AZURE_LEAVES = OuterEndBlocks.registerBlock("azure_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220838_)));
    public static final RegistryObject<Block> AZURE_STAMEN = OuterEndBlocks.registerBlock("azure_stamen", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50701_)));
    public static final RegistryObject<Block> AZURE_BUD = OuterEndBlocks.registerBlock("azure_bud", () -> new EndSaplingBlock(new AzureTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> AZURE_GRASS = OuterEndBlocks.registerBlock("azure_grass", () -> new AzureGrassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_), () -> Blocks.f_50259_));
    public static final RegistryObject<Block> AZURE_SPROUTS = OuterEndBlocks.registerBlock("azure_sprouts", () -> new EnderTallGrassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60918_(SoundType.f_154662_)));
    public static final RegistryObject<Block> ENDER_ROOTS = OuterEndBlocks.registerBlock("ender_roots", () -> new EnderTallGrassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60918_(SoundType.f_154662_)));
    public static final RegistryObject<Block> TALL_ENDER_ROOTS = OuterEndBlocks.registerBlock("tall_ender_roots", () -> new EnderDoublePlant(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60918_(SoundType.f_154662_)));
    public static final RegistryObject<Block> AZURE_VINES = OuterEndBlocks.registerBlock("azure_vines", () -> new VineBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50191_)));
    public static final RegistryObject<Block> AZURE_BERRY_VINE = BLOCKS.register("azure_berry_vine", () -> new AzureBerryVineBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50704_)));
    public static final RegistryObject<Block> AZURE_BERRY_VINE_TOP = BLOCKS.register("azure_berry_vine_top", () -> new AzureBerryVineTop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50704_)));
    public static final RegistryObject<Block> HIMMEL_BLOCK = OuterEndBlocks.registerBlock("himmel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50492_).m_284180_(MapColor.f_283869_)));
    public static final RegistryObject<Block> HIMMEL_PILLAR = OuterEndBlocks.registerBlock("himmel_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)HIMMEL_BLOCK.get()))));
    public static final RegistryObject<Block> HIMMEL_SLAB = OuterEndBlocks.registerBlock("himmel_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)HIMMEL_BLOCK.get()))));
    public static final RegistryObject<Block> HIMMEL_STAIRS = OuterEndBlocks.registerBlock("himmel_stairs", () -> new StairBlock(() -> ((Block)HIMMEL_BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)HIMMEL_BLOCK.get()))));
    public static final RegistryObject<Block> VIOLITE = OuterEndBlocks.registerBlock("violite", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_155956_(6.0f).m_60999_().m_60978_(2.0f).m_60918_(OuterEndSounds.VIOLITE_SOUND)));
    public static final RegistryObject<Block> VIOLITE_SLAB = OuterEndBlocks.registerBlock("violite_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_STAIRS = OuterEndBlocks.registerBlock("violite_stairs", () -> new StairBlock(() -> ((Block)VIOLITE.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_BRICKS = OuterEndBlocks.registerBlock("violite_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_BRICK_SLAB = OuterEndBlocks.registerBlock("violite_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_BRICK_STAIRS = OuterEndBlocks.registerBlock("violite_brick_stairs", () -> new StairBlock(() -> ((Block)VIOLITE_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_BRICK_WALL = OuterEndBlocks.registerBlock("violite_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_BRICK_PILLAR = OuterEndBlocks.registerBlock("violite_brick_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> MOSSY_VIOLITE_BRICKS = OuterEndBlocks.registerBlock("mossy_violite_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> MOSSY_VIOLITE_BRICK_SLAB = OuterEndBlocks.registerBlock("mossy_violite_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> MOSSY_VIOLITE_BRICK_STAIRS = OuterEndBlocks.registerBlock("mossy_violite_brick_stairs", () -> new StairBlock(() -> ((Block)MOSSY_VIOLITE_BRICKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> MOSSY_VIOLITE_BRICK_WALL = OuterEndBlocks.registerBlock("mossy_violite_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> CRACKED_VIOLITE_BRICKS = OuterEndBlocks.registerBlock("cracked_violite_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> CHISELED_VIOLITE_BRICKS = OuterEndBlocks.registerBlock("chiseled_violite_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_TILES = OuterEndBlocks.registerBlock("violite_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_TILE_SLAB = OuterEndBlocks.registerBlock("violite_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> VIOLITE_TILE_STAIRS = OuterEndBlocks.registerBlock("violite_tile_stairs", () -> new StairBlock(() -> ((Block)VIOLITE_TILES.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> MOSSY_VIOLITE_TILES = OuterEndBlocks.registerBlock("mossy_violite_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> MOSSY_VIOLITE_TILE_SLAB = OuterEndBlocks.registerBlock("mossy_violite_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> MOSSY_VIOLITE_TILE_STAIRS = OuterEndBlocks.registerBlock("mossy_violite_tile_stairs", () -> new StairBlock(() -> ((Block)MOSSY_VIOLITE_TILES.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> CRACKED_VIOLITE_TILES = OuterEndBlocks.registerBlock("cracked_violite_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get()))));
    public static final RegistryObject<Block> ROSE_CRYSTAL = OuterEndBlocks.registerBlock("rose_crystal", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283765_).m_60953_(e -> 13).m_60955_()));
    public static final RegistryObject<Block> MINT_CRYSTAL = OuterEndBlocks.registerBlock("mint_crystal", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283916_).m_60953_(e -> 13).m_60955_()));
    public static final RegistryObject<Block> COBALT_CRYSTAL = OuterEndBlocks.registerBlock("cobalt_crystal", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283869_).m_60953_(e -> 13).m_60955_()));
    public static final RegistryObject<Block> ROSE_CRYSTAL_BUD = OuterEndBlocks.registerBlock("rose_crystal_bud", () -> new AmethystClusterBlock(12, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283765_).m_60953_(e -> 8)));
    public static final RegistryObject<Block> MINT_CRYSTAL_BUD = OuterEndBlocks.registerBlock("mint_crystal_bud", () -> new AmethystClusterBlock(12, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283916_).m_60953_(e -> 8)));
    public static final RegistryObject<Block> COBALT_CRYSTAL_BUD = OuterEndBlocks.registerBlock("cobalt_crystal_bud", () -> new AmethystClusterBlock(12, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283869_).m_60953_(e -> 8)));
    public static final RegistryObject<Block> ROSE_CRYSTAL_LAMP = OuterEndBlocks.registerBlock("rose_crystal_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283765_).m_60953_(e -> 15).m_60955_()));
    public static final RegistryObject<Block> MINT_CRYSTAL_LAMP = OuterEndBlocks.registerBlock("mint_crystal_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283916_).m_60953_(e -> 15).m_60955_()));
    public static final RegistryObject<Block> COBALT_CRYSTAL_LAMP = OuterEndBlocks.registerBlock("cobalt_crystal_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283869_).m_60953_(e -> 15).m_60955_()));
    public static final RegistryObject<Block> ROSE_TANGLED_VIOLITE = OuterEndBlocks.registerBlock("rose_tangled_violite", () -> new TangledVioliteBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get())), (Block)ROSE_CRYSTAL_BUD.get()));
    public static final RegistryObject<Block> MINT_TANGLED_VIOLITE = OuterEndBlocks.registerBlock("mint_tangled_violite", () -> new TangledVioliteBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get())), (Block)MINT_CRYSTAL_BUD.get()));
    public static final RegistryObject<Block> COBALT_TANGLED_VIOLITE = OuterEndBlocks.registerBlock("cobalt_tangled_violite", () -> new TangledVioliteBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get())), (Block)COBALT_CRYSTAL_BUD.get()));
    public static final RegistryObject<Block> ROSE_ROOTS = OuterEndBlocks.registerBlock("rose_roots", () -> new AmethystClusterBlock(12, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get())).m_284180_(MapColor.f_283765_).m_60910_().m_60966_().m_280170_()));
    public static final RegistryObject<Block> MINT_ROOTS = OuterEndBlocks.registerBlock("mint_roots", () -> new AmethystClusterBlock(12, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get())).m_284180_(MapColor.f_283916_).m_60910_().m_60966_().m_280170_()));
    public static final RegistryObject<Block> COBALT_ROOTS = OuterEndBlocks.registerBlock("cobalt_roots", () -> new AmethystClusterBlock(12, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)VIOLITE.get())).m_284180_(MapColor.f_283869_).m_60910_().m_60966_().m_280170_()));
    public static final RegistryObject<Block> STROMATOLITE = OuterEndBlocks.registerBlock("stromatolite", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_).m_284180_(MapColor.f_283875_)));
    public static final RegistryObject<Block> HALITE = OuterEndBlocks.registerBlock("halite", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_).m_284180_(MapColor.f_283779_)));
    public static final RegistryObject<Block> BRINE = BLOCKS.register("brine", () -> new BrineBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152499_).m_60955_()));
    public static final RegistryObject<Block> ANCIENT_STONE = OuterEndBlocks.registerBlock("ancient_stone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152597_)));
    public static final RegistryObject<Block> ANCIENT_ICE = OuterEndBlocks.registerBlock("ancient_ice", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50568_).m_60999_().m_60913_(3.0f, 2.0f)));
    public static final RegistryObject<Block> ANCIENT_ICE_COLUMN = OuterEndBlocks.registerBlock("ancient_ice_column", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ANCIENT_ICE.get()))));
    public static final RegistryObject<Block> ANCIENT_ICE_CAP = OuterEndBlocks.registerBlock("ancient_ice_cap", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ANCIENT_ICE.get())).m_60911_(0.6f)));
    public static final RegistryObject<Block> GLOWING_ANCIENT_ICE = OuterEndBlocks.registerBlock("glowing_ancient_ice", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ANCIENT_ICE.get())).m_60953_(e -> 6)));
    public static final RegistryObject<Block> GLOWING_ANCIENT_ICE_COLUMN = OuterEndBlocks.registerBlock("glowing_ancient_ice_column", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLOWING_ANCIENT_ICE.get()))));
    public static final RegistryObject<Block> GLOWING_ANCIENT_ICE_CAP = OuterEndBlocks.registerBlock("glowing_ancient_ice_cap", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLOWING_ANCIENT_ICE.get())).m_60911_(0.6f)));
    public static final RegistryObject<Block> OMINOUS_MIASMA = BLOCKS.register("ominous_miasma", () -> new MiasmaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152499_).m_60955_().m_60910_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        OuterEndBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerQuarkBlock(String name, Supplier<T> block) {
        if (ModList.get().isLoaded("quark")) {
            RegistryObject toReturn = BLOCKS.register(name, block);
            OuterEndBlocks.registerBlockItem(name, toReturn);
            return toReturn;
        }
        return null;
    }

    private static <T extends Block> RegistryObject<T> registerQuarkChest(String name, BlockBehaviour.Properties properties, boolean trapped) {
        if (ModList.get().isLoaded("quark")) {
            RegistryObject toReturn = trapped ? HELPER.createTrappedChestBlock(name, properties) : HELPER.createChestBlock(name, properties);
            return toReturn;
        }
        return null;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return OuterEndItems.BLOCK_ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> registerFlammableBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        OuterEndBlocks.registerFuelBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerFuelBlockItem(String name, RegistryObject<T> block) {
        return OuterEndItems.BLOCK_ITEMS.register(name, () -> new FuelBlockItem((Block)block.get(), 200, new Item.Properties()));
    }
}

