/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.stargate;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Dialing;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class SGJourneyStargate
implements Stargate {
    private Address.Immutable address;
    @Nullable
    private WeakReference<AbstractStargateEntity> stargate;
    private ResourceKey<Level> dimension;
    private BlockPos blockPos;
    private boolean hasDHD;
    private StargateInfo.Gen generation;
    private int timesOpened;
    private int network;

    public SGJourneyStargate() {
    }

    public SGJourneyStargate(AbstractStargateEntity stargate) {
        this.address = stargate.get9ChevronAddress().immutable();
        this.dimension = stargate.m_58904_().m_46472_();
        this.blockPos = stargate.m_58899_();
        this.hasDHD = stargate.dhdInfo().hasDHD();
        this.generation = stargate.getGeneration();
        this.timesOpened = stargate.getTimesOpened();
        this.network = stargate.getNetwork();
        this.cacheStargateEntity(stargate);
    }

    @Override
    public Address.Immutable get9ChevronAddress() {
        return this.address;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    public boolean hasDHD() {
        return this.hasDHD;
    }

    @Override
    public StargateInfo.Gen getGeneration() {
        return this.generation;
    }

    @Override
    public int getTimesOpened() {
        return this.timesOpened;
    }

    @Override
    public int getNetwork() {
        return this.network;
    }

    private AbstractStargateEntity cacheStargateEntity(AbstractStargateEntity stargate) {
        return stargate;
    }

    @Nullable
    private AbstractStargateEntity tryCacheStargateEntity(MinecraftServer server) {
        BlockEntity blockEntity;
        ServerLevel level = server.m_129880_(this.dimension);
        if (level != null && (blockEntity = level.m_7702_(this.blockPos)) instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return this.cacheStargateEntity(stargate);
        }
        return null;
    }

    @Override
    @Nullable
    public AbstractStargateEntity getStargateEntity(MinecraftServer server) {
        return this.tryCacheStargateEntity(server);
    }

    @Override
    public StargateInfo.Feedback resetStargate(MinecraftServer server, StargateInfo.Feedback feedback, boolean updateInterfaces) {
        AbstractStargateEntity stargateEntity = this.getStargateEntity(server);
        this.stargate = null;
        if (stargateEntity != null) {
            return stargateEntity.resetStargate(feedback, updateInterfaces);
        }
        StargateJourney.LOGGER.error("Failed to reset Stargate as it does not exist");
        return feedback;
    }

    @Override
    public boolean isConnected(MinecraftServer server) {
        AbstractStargateEntity stargateEntity = this.getStargateEntity(server);
        if (stargateEntity != null) {
            return stargateEntity.isConnected();
        }
        return false;
    }

    @Override
    public boolean isObstructed(MinecraftServer server) {
        AbstractStargateEntity stargateEntity = this.getStargateEntity(server);
        if (stargateEntity != null) {
            return stargateEntity.isConnected();
        }
        return false;
    }

    @Override
    public boolean canExtractEnergy(MinecraftServer server, long energy) {
        AbstractStargateEntity stargateEntity = this.getStargateEntity(server);
        if (stargateEntity != null) {
            return stargateEntity.canExtractEnergy(energy);
        }
        return false;
    }

    @Override
    public void depleteEnergy(MinecraftServer server, long energy, boolean simulate) {
        AbstractStargateEntity stargateEntity = this.getStargateEntity(server);
        if (stargateEntity != null) {
            stargateEntity.depleteEnergy(energy, simulate);
        }
    }

    @Override
    public StargateInfo.Feedback tryConnect(MinecraftServer server, Stargate dialingStargate, Address.Type addressType, Address.Immutable dialingAddress, boolean doKawoosh) {
        AbstractStargateEntity targetStargateEntity = this.getStargateEntity(server);
        if (targetStargateEntity == null) {
            return StargateInfo.Feedback.UNKNOWN_ERROR;
        }
        if (targetStargateEntity.isObstructed()) {
            return StargateInfo.Feedback.TARGET_OBSTRUCTED;
        }
        if (targetStargateEntity.isRestricted(dialingStargate.getNetwork())) {
            return StargateInfo.Feedback.TARGET_RESTRICTED;
        }
        if (targetStargateEntity.addressFilterInfo().getFilterType().isBlacklist() && targetStargateEntity.addressFilterInfo().isAddressBlacklisted(dialingAddress)) {
            return StargateInfo.Feedback.BLACKLISTED_SELF;
        }
        if (targetStargateEntity.addressFilterInfo().getFilterType().isWhitelist() && !targetStargateEntity.addressFilterInfo().isAddressWhitelisted(dialingAddress)) {
            return StargateInfo.Feedback.WHITELISTED_SELF;
        }
        return Dialing.connectStargates(server, dialingStargate, this, addressType, doKawoosh);
    }

    @Override
    public boolean isPrimary(MinecraftServer server) {
        AbstractStargateEntity stargateEntity = this.getStargateEntity(server);
        if (stargateEntity != null) {
            return stargateEntity.isPrimary();
        }
        return false;
    }

    @Override
    public void update(AbstractStargateEntity stargate) {
        this.hasDHD = stargate.dhdInfo().hasDHD();
        this.generation = stargate.getGeneration();
        this.timesOpened = stargate.getTimesOpened();
        this.network = stargate.getNetwork();
    }

    @Override
    public boolean checkStargateEntity(MinecraftServer server) {
        AbstractStargateEntity stargate = this.getStargateEntity(server);
        if (stargate != null) {
            stargate.checkStargate();
            return true;
        }
        StargateJourney.LOGGER.error("Stargate not found");
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag stargateTag = new CompoundTag();
        ResourceKey<Level> level = this.getDimension();
        BlockPos pos = this.getBlockPos();
        stargateTag.m_128359_("Dimension", level.m_135782_().toString());
        stargateTag.m_128385_("Coordinates", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        stargateTag.m_128379_("HasDHD", this.hasDHD);
        stargateTag.m_128405_("Generation", this.generation.getGen());
        stargateTag.m_128405_("TimesOpened", this.timesOpened);
        stargateTag.m_128405_("Network", this.network);
        return stargateTag;
    }

    @Override
    public void deserializeNBT(MinecraftServer server, Address.Immutable address, CompoundTag tag) {
        this.address = address;
        this.dimension = Conversion.stringToDimension(tag.m_128461_("Dimension"));
        this.blockPos = Conversion.intArrayToBlockPos(tag.m_128465_("Coordinates"));
        if (!(tag.m_128441_("HasDHD") && tag.m_128441_("Generation") && tag.m_128441_("TimesOpened") && tag.m_128441_("Network"))) {
            BlockEntity blockEntity = server.m_129880_(this.dimension).m_7702_(this.blockPos);
            if (blockEntity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                this.hasDHD = stargate.dhdInfo().hasDHD();
                this.generation = stargate.getGeneration();
                this.timesOpened = stargate.getTimesOpened();
                this.network = stargate.getNetwork();
                this.cacheStargateEntity(stargate);
            } else {
                StargateJourney.LOGGER.info("Failed to deserialize Stargate " + address.toString());
            }
        } else {
            this.hasDHD = tag.m_128471_("HasDHD");
            this.generation = StargateInfo.Gen.intToGen(tag.m_128451_("Generation"));
            this.timesOpened = tag.m_128451_("TimesOpened");
            this.network = tag.m_128451_("Network");
            this.stargate = null;
        }
    }

    public String toString() {
        return "[ " + this.address.toString() + " | DHD: " + this.hasDHD + " | Generation: " + this.generation + " | Times Opened: " + this.timesOpened + " ]";
    }
}

