/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.misc.ArrayHelper;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.info.AddressFilterInfo;

public final class Address {
    public static final String ADDRESS_DIVIDER = "-";
    public static final int MIN_ADDRESS_LENGTH = 6;
    public static final int MAX_ADDRESS_LENGTH = 9;
    private int[] addressArray = new int[0];
    private boolean isBuffer = false;
    @Nullable
    private ResourceKey<Level> dimension;
    public static final Codec<Address> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("symbols").forGetter(address -> Arrays.stream(address.addressArray).boxed().collect(Collectors.toList()))).apply((Applicative)instance, Address::new));

    public Address(boolean isBuffer) {
        this.isBuffer = isBuffer;
    }

    public Address() {
        this(false);
    }

    public Address(int[] addressArray) {
        this.fromArray(addressArray);
    }

    public Address(String addressString) {
        this.fromString(addressString);
    }

    public Address(Map<Double, Double> addressTable) {
        this.fromTable(addressTable);
    }

    public Address(List<Integer> addressList) {
        this.fromIntegerList(addressList);
    }

    public Address(MinecraftServer server, ResourceKey<Level> dimension) {
        this.fromDimension(server, dimension);
    }

    public Address addSymbol(int symbol) {
        if (this.hasPointOfOrigin()) {
            return this;
        }
        if (symbol < 0) {
            return this;
        }
        if (symbol == 0 && !this.isBuffer) {
            return this;
        }
        if (!this.canGrow()) {
            return this;
        }
        this.addressArray = ArrayHelper.growIntArray(this.addressArray, symbol);
        return this;
    }

    public Address fromArray(int[] addressArray) {
        this.dimension = null;
        if (addressArray.length < this.getMaxAddressLength() && ArrayHelper.differentNumbers(addressArray) && ArrayHelper.isArrayPositive(addressArray, this.isBuffer)) {
            this.addressArray = addressArray;
        }
        return this;
    }

    public Address fromString(String addressString) {
        this.dimension = null;
        int[] addressArray = Address.addressStringToIntArray(addressString);
        if (addressArray.length < this.getMaxAddressLength() && ArrayHelper.differentNumbers(addressArray)) {
            this.addressArray = addressArray;
        }
        return this;
    }

    public Address fromTable(Map<Double, Double> addressTable) {
        this.dimension = null;
        int[] addressArray = ArrayHelper.tableToArray(addressTable);
        if (addressArray.length < this.getMaxAddressLength() && ArrayHelper.differentNumbers(addressArray)) {
            this.addressArray = addressArray;
        }
        return this;
    }

    public Address fromIntegerList(List<Integer> integerList) {
        this.dimension = null;
        int[] addressArray = Address.integerListToArray(integerList);
        if (addressArray.length < this.getMaxAddressLength() && ArrayHelper.differentNumbers(addressArray)) {
            this.addressArray = addressArray;
        }
        return this;
    }

    public Address fromDimensionAndGalaxy(MinecraftServer server, ResourceKey<Level> dimension, Galaxy.Serializable galaxy) {
        Immutable address = Universe.get(server).getAddressInGalaxyFromDimension(galaxy.getKey().m_135782_(), dimension);
        if (address != null) {
            this.fromArray(address.toArray());
            this.dimension = dimension;
        }
        return this;
    }

    public Address fromDimension(MinecraftServer server, ResourceKey<Level> dimension) {
        Galaxy.Serializable galaxy = Universe.get(server).getGalaxyFromDimension(dimension);
        if (galaxy != null) {
            this.fromDimensionAndGalaxy(server, dimension, galaxy);
        }
        return this;
    }

    public int[] toArray() {
        return this.addressArray;
    }

    public List<Integer> toList() {
        return Arrays.stream(this.toArray()).boxed().toList();
    }

    public int getLength() {
        return this.addressArray.length;
    }

    public int getSymbol(int number) {
        if (number < 0 || number >= this.getLength()) {
            return 0;
        }
        return this.addressArray[number];
    }

    public boolean isEmpty() {
        return this.getLength() <= 0;
    }

    public boolean isComplete() {
        return this.getLength() >= 6;
    }

    public int getMaxAddressLength() {
        return this.isBuffer ? 10 : 9;
    }

    public boolean canGrow() {
        return this.getLength() < this.getMaxAddressLength() - 1;
    }

    public boolean hasPointOfOrigin() {
        return this.containsSymbol(0);
    }

    public boolean isBuffer() {
        return this.isBuffer;
    }

    public boolean isFromDimension() {
        return this.dimension != null;
    }

    @Nullable
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public Type getType() {
        return Type.fromInt(this.getLength());
    }

    public String toString() {
        return Address.addressIntArrayToString(this.addressArray);
    }

    public Component toComponent(boolean copyToClipboard) {
        ChatFormatting chatFormatting = switch (this.getType()) {
            case Type.ADDRESS_7_CHEVRON -> ChatFormatting.GOLD;
            case Type.ADDRESS_8_CHEVRON -> ChatFormatting.LIGHT_PURPLE;
            case Type.ADDRESS_9_CHEVRON -> ChatFormatting.AQUA;
            default -> ChatFormatting.GRAY;
        };
        Style style = Style.f_131099_;
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.toString()));
        return Component.m_237113_((String)Address.addressIntArrayToString(this.addressArray)).m_6270_(style.m_131157_(chatFormatting));
    }

    public Address reset() {
        this.addressArray = new int[0];
        return this;
    }

    public boolean containsSymbol(int symbol) {
        for (int i = 0; i < this.getLength(); ++i) {
            if (this.addressArray[i] != symbol) continue;
            return true;
        }
        return false;
    }

    public Address randomAddress(int size, int limit, long seed) {
        return this.randomAddress(0, size, limit, seed);
    }

    public Address randomAddress(int prefix, int size, int limit, long seed) {
        size = size > 9 ? 9 : size;
        Random random = new Random(seed);
        int[] addressArray = new int[size];
        boolean isValid = false;
        while (!isValid) {
            for (int i = 0; i < size; ++i) {
                addressArray[i] = i == 0 && prefix > 0 && prefix < limit ? prefix : random.nextInt(1, limit);
            }
            if (!ArrayHelper.differentNumbers(addressArray)) continue;
            isValid = true;
        }
        this.addressArray = addressArray;
        return this;
    }

    public Address copy() {
        Address copyAddress = new Address(this.isBuffer).fromArray(this.addressArray);
        copyAddress.dimension = this.dimension;
        return copyAddress;
    }

    public boolean equals(Object object) {
        if (object instanceof Address) {
            Address address = (Address)object;
            return Arrays.equals(this.addressArray, address.addressArray);
        }
        if (object instanceof Immutable) {
            Immutable address = (Immutable)object;
            return Arrays.equals(this.addressArray, address.addressArray);
        }
        if (object instanceof AddressFilterInfo.HiddenAddress) {
            AddressFilterInfo.HiddenAddress hiddenAddress = (AddressFilterInfo.HiddenAddress)object;
            return Arrays.equals(this.addressArray, hiddenAddress.address().addressArray);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getSymbol(0), this.getSymbol(1), this.getSymbol(2), this.getSymbol(3), this.getSymbol(4), this.getSymbol(5), this.getSymbol(6), this.getSymbol(7));
    }

    public Immutable immutable() {
        return new Immutable(this);
    }

    private static boolean isAllowedInAddress(char character) {
        return character == '-' || character >= '0' && character <= '9';
    }

    public static Immutable read(StringReader reader) {
        int i = reader.getCursor();
        while (reader.canRead() && Address.isAllowedInAddress(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(i, reader.getCursor());
        return new Immutable(string);
    }

    public static boolean canBeTransformedToAddress(String addressString) {
        for (int i = 0; i < addressString.length(); ++i) {
            char character = addressString.charAt(i);
            if (Character.isDigit(character) || character == '-') continue;
            return false;
        }
        return true;
    }

    public static int[] addressStringToIntArray(String addressString) {
        if (addressString == null || !Address.canBeTransformedToAddress(addressString)) {
            return new int[0];
        }
        String[] stringArray = addressString.split(ADDRESS_DIVIDER);
        int[] intArray = new int[]{};
        for (int i = 1; i < stringArray.length; ++i) {
            int number = Character.getNumericValue(stringArray[i].charAt(0));
            int length = stringArray[i].length();
            if (length > 1) {
                number = number * 10 + Character.getNumericValue(stringArray[i].charAt(1));
            }
            intArray = ArrayHelper.growIntArray(intArray, number);
        }
        return intArray;
    }

    public static String addressIntArrayToString(int[] array) {
        Object address = ADDRESS_DIVIDER;
        for (int i = 0; i < array.length; ++i) {
            address = (String)address + array[i] + ADDRESS_DIVIDER;
        }
        return address;
    }

    public static int[] integerListToArray(List<Integer> integerList) {
        return integerList.stream().mapToInt(integer -> integer).toArray();
    }

    public static final class Immutable {
        private final int[] addressArray;

        public Immutable(String addressString) {
            this.addressArray = new Address(addressString).toArray();
        }

        public Immutable(int[] addressArray) {
            this.addressArray = new Address(addressArray).toArray();
        }

        public Immutable(Address address) {
            this.addressArray = address.toArray();
        }

        public final int getLength() {
            return this.addressArray.length;
        }

        public final int getSymbol(int number) {
            if (number < 0 || number >= this.getLength()) {
                return 0;
            }
            return this.addressArray[number];
        }

        public final int[] toArray() {
            return this.addressArray;
        }

        public final List<Integer> toList() {
            return Arrays.stream(this.toArray()).boxed().toList();
        }

        public final String toString() {
            return Address.addressIntArrayToString(this.addressArray);
        }

        public final Type getType() {
            return Type.fromInt(this.getLength());
        }

        public final Component toComponent(boolean copyToClipboard) {
            ChatFormatting chatFormatting = switch (this.getType()) {
                case Type.ADDRESS_7_CHEVRON -> ChatFormatting.GOLD;
                case Type.ADDRESS_8_CHEVRON -> ChatFormatting.LIGHT_PURPLE;
                case Type.ADDRESS_9_CHEVRON -> ChatFormatting.AQUA;
                default -> ChatFormatting.GRAY;
            };
            Style style = Style.f_131099_;
            if (copyToClipboard) {
                style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
                style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.toString()));
            }
            return Component.m_237113_((String)Address.addressIntArrayToString(this.addressArray)).m_6270_(style.m_131157_(chatFormatting));
        }

        public final boolean containsSymbol(int symbol) {
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.addressArray[i] != symbol) continue;
                return true;
            }
            return false;
        }

        public final Immutable copy() {
            Immutable copyAddress = new Address(true).fromArray(this.addressArray).immutable();
            return copyAddress;
        }

        public final boolean equals(Object object) {
            if (object instanceof Immutable) {
                Immutable address = (Immutable)object;
                return Arrays.equals(this.addressArray, address.addressArray);
            }
            if (object instanceof Address) {
                Address address = (Address)object;
                return Arrays.equals(this.addressArray, address.addressArray);
            }
            if (object instanceof AddressFilterInfo.HiddenAddress) {
                AddressFilterInfo.HiddenAddress hiddenAddress = (AddressFilterInfo.HiddenAddress)object;
                return Arrays.equals(this.addressArray, hiddenAddress.address().addressArray);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.getSymbol(0), this.getSymbol(1), this.getSymbol(2), this.getSymbol(3), this.getSymbol(4), this.getSymbol(5), this.getSymbol(6), this.getSymbol(7));
        }

        public final Address mutable() {
            return new Address(this.addressArray);
        }
    }

    public static enum Type {
        ADDRESS_INVALID(0),
        ADDRESS_9_CHEVRON(8),
        ADDRESS_8_CHEVRON(7),
        ADDRESS_7_CHEVRON(6);

        private byte value;

        private Type(byte value) {
            this.value = value;
        }

        public byte byteValue() {
            return this.value;
        }

        public static final Type fromInt(int addressLength) {
            switch (addressLength) {
                case 6: {
                    return ADDRESS_7_CHEVRON;
                }
                case 7: {
                    return ADDRESS_8_CHEVRON;
                }
                case 8: {
                    return ADDRESS_9_CHEVRON;
                }
            }
            return ADDRESS_INVALID;
        }
    }
}

