/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.povstalec.sgjourney.common.items.GDOItem;

public class ServerboundGDOUpdatePacket {
    public final boolean mainHand;
    public final String idc;
    public final int frequency;
    public final boolean transmit;

    public ServerboundGDOUpdatePacket(boolean mainHand, int frequency, String idc, boolean transmit) {
        this.mainHand = mainHand;
        this.idc = idc;
        this.frequency = frequency;
        this.transmit = transmit;
    }

    public ServerboundGDOUpdatePacket(FriendlyByteBuf buffer) {
        this(buffer.readBoolean(), buffer.readInt(), buffer.m_130277_(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.mainHand);
        buffer.writeInt(this.frequency);
        buffer.m_130070_(this.idc);
        buffer.writeBoolean(this.transmit);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack stack = player.m_21120_(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            if (stack.m_41720_() instanceof GDOItem) {
                GDOItem.setFrequencyAndIDC(stack, this.frequency, this.idc);
                if (this.transmit) {
                    GDOItem.sendTransmission(player.m_9236_(), (Player)player, stack);
                }
            }
        });
        return true;
    }
}

