/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class Conversion {
    public static final ResourceLocation DIMENSION_LOCATION = new ResourceLocation("minecraft", "dimension");
    public static final ResourceKey<Registry<Level>> DIMENSION_KEY = ResourceKey.m_135788_((ResourceLocation)DIMENSION_LOCATION);

    @Nullable
    public static ResourceKey<Level> locationToDimension(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(DIMENSION_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Level> stringToDimension(String dimensionString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)dimensionString);
        if (location != null) {
            return Conversion.locationToDimension(location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<PointOfOrigin> locationToPointOfOrigin(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(PointOfOrigin.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<PointOfOrigin> stringToPointOfOrigin(String pointOfOriginString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)pointOfOriginString);
        return Conversion.locationToPointOfOrigin(location);
    }

    @Nullable
    public static ResourceKey<Symbols> locationToSymbols(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(Symbols.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Symbols> stringToSymbols(String symbolsString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)symbolsString);
        return Conversion.locationToSymbols(location);
    }

    @Nullable
    public static ResourceKey<Galaxy> locationToGalaxyKey(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(Galaxy.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Galaxy> stringToGalaxyKey(String galaxyString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)galaxyString);
        return Conversion.locationToGalaxyKey(location);
    }

    @Nullable
    public static ResourceKey<SolarSystem> locationToSolarSystemKey(ResourceLocation location) {
        if (location != null) {
            return ResourceKey.m_135785_(SolarSystem.REGISTRY_KEY, (ResourceLocation)location);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<SolarSystem> stringToSolarSystemKey(String solarSystemString) {
        ResourceLocation location = ResourceLocation.m_135820_((String)solarSystemString);
        return Conversion.locationToSolarSystemKey(location);
    }

    public static BlockPos intArrayToBlockPos(int[] coordinates) {
        if (coordinates.length >= 3) {
            return new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
        }
        return null;
    }
}

