/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.PegasusDHDEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;

public class DHDCrystalMenu
extends AbstractContainerMenu {
    private final AbstractDHDEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;

    public DHDCrystalMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public DHDCrystalMenu(int containerId, Inventory inv, BlockEntity entity) {
        super((MenuType)MenuInit.DHD_CRYSTAL.get(), containerId);
        DHDCrystalMenu.m_38869_((Container)inv, (int)9);
        this.blockEntity = (AbstractDHDEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 80, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 80, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 98, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 98, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 98, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 80, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 6, 62, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 7, 62, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 8, 62, 17));
        });
        this.blockEntity.getEnergyItemHandler().ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 134, 27));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 134, 53));
        });
    }

    public boolean advancedCrystals() {
        return this.blockEntity instanceof PegasusDHDEntity;
    }

    public long getEnergy() {
        return this.blockEntity.getEnergyStored();
    }

    public long getMaxEnergy() {
        return this.blockEntity.getEnergyCapacity();
    }

    public boolean enableAdvancedProtocols() {
        return this.blockEntity.enableAdvancedProtocols();
    }

    public long getEnergyTarget() {
        return this.blockEntity.getEnergyTarget();
    }

    public long maxEnergyDeplete() {
        return this.blockEntity.maxEnergyDeplete();
    }

    public int getMaxDistance() {
        return this.blockEntity.getMaxDistance();
    }

    public boolean hasItem(int slot) {
        if (slot < 0 || slot > 8) {
            return false;
        }
        IItemHandler cap = (IItemHandler)this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (cap != null && cap.getStackInSlot(slot) != null) {
            return !cap.getStackInSlot(slot).m_41619_();
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return DHDCrystalMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.MILKY_WAY_DHD.get())) || DHDCrystalMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.PEGASUS_DHD.get())) || DHDCrystalMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.CLASSIC_DHD.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 144));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 46, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 46) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }
}

