/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractCrystallizerEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;

public class CrystallizerMenu
extends AbstractContainerMenu {
    protected final AbstractCrystallizerEntity blockEntity;
    protected final Level level;
    protected FluidStack fluidStack;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 5;

    public CrystallizerMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public CrystallizerMenu(int containerId, Inventory inventory, BlockEntity blockEntity) {
        super((MenuType)MenuInit.CRYSTALLIZER.get(), containerId);
        CrystallizerMenu.m_38869_((Container)inventory, (int)5);
        this.blockEntity = (AbstractCrystallizerEntity)blockEntity;
        this.level = inventory.f_35978_.m_9236_();
        this.fluidStack = this.blockEntity.getFluid();
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.blockEntity.getItemHandler(0).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 80, 20)));
        this.blockEntity.getItemHandler(1).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 67, 50)));
        this.blockEntity.getItemHandler(2).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 93, 50)));
        this.blockEntity.getItemHandler(3).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 130, 36)));
        this.blockEntity.getItemHandler(4).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 34, 20)));
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidStack getFluid() {
        return this.blockEntity.getFluid();
    }

    public Fluid getDesiredFluid() {
        return this.blockEntity.getDesiredFluid();
    }

    public int getProgress() {
        return this.blockEntity.progress;
    }

    public boolean m_6875_(Player player) {
        return CrystallizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.CRYSTALLIZER.get())) || CrystallizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.ADVANCED_CRYSTALLIZER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 41, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 41) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }
}

