/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public class Human
extends AgeableMob
implements RangedAttackMob {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/player/wide/makena.png");

    public Human(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
    }

    public ResourceLocation texture() {
        return TEXTURE;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AgeableMob.m_21552_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public void m_6504_(LivingEntity entity, float distanceFactor) {
        this.performStaffWeaponAttack(entity, distanceFactor);
    }

    public void performStaffWeaponAttack(LivingEntity entity, float distanceFactor) {
        ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof StaffWeaponItem));
        Item item2 = itemstack.m_41720_();
        if (item2 instanceof StaffWeaponItem) {
            StaffWeaponItem staffWeapon = (StaffWeaponItem)item2;
            PlasmaProjectile plasmaProjectile = new PlasmaProjectile((EntityType<? extends Projectile>)((EntityType)EntityInit.JAFFA_PLASMA.get()), (LivingEntity)this, this.m_9236_(), staffWeapon.getExplosionPower(itemstack));
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - plasmaProjectile.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double distance = Math.sqrt(x * x + z * z);
            plasmaProjectile.m_6686_(x, y + distance * 0.125, z, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
            this.m_5496_((SoundEvent)SoundInit.MATOK_FIRE.get(), 0.25f, 1.0f);
            this.m_9236_().m_7967_((Entity)plasmaProjectile);
        }
    }
}

