/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;

public abstract class ZeroPointEnergy
extends SGJourneyEnergy {
    protected int maxEntropy;
    protected int entropy;

    public ZeroPointEnergy(int maxEntropy, long capacity, long maxReceive, long maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.maxEntropy = maxEntropy;
        this.energy = capacity;
    }

    @Override
    public long receiveLongEnergy(long maxReceive, boolean simulate) {
        return 0L;
    }

    @Override
    public long extractLongEnergy(long maxExtract, boolean simulate) {
        long energyExtracted;
        if (!this.canExtract()) {
            return 0L;
        }
        long l = energyExtracted = !this.isNearMaxEntropy() ? Math.min(this.maxExtract, maxExtract) : Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!this.isNearMaxEntropy() && energyExtracted > this.energy) {
            long leftover = energyExtracted - this.energy;
            if (!simulate) {
                ++this.entropy;
                this.energy = this.capacity - leftover;
            }
            if (energyExtracted != 0L) {
                this.onEnergyChanged(energyExtracted, simulate);
            }
            return energyExtracted;
        }
        if (!simulate) {
            this.energy -= energyExtracted;
            if (this.energy <= 0L && this.entropy < 1000) {
                ++this.entropy;
            }
        }
        if (energyExtracted != 0L) {
            this.onEnergyChanged(energyExtracted, simulate);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored() {
        return ZeroPointEnergy.getRegularEnergy(this.getTrueEnergyStored());
    }

    @Override
    public long getTrueEnergyStored() {
        return this.energy;
    }

    public int getEntropy() {
        return this.entropy;
    }

    public int setEntropy(int entropy) {
        this.entropy = entropy;
        return this.entropy;
    }

    public boolean isNearMaxEntropy() {
        return this.entropy >= this.maxEntropy - 1;
    }

    public Tag serializeEntropy() {
        return IntTag.m_128679_((int)this.entropy);
    }

    public void deserializeEntropy(Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intTag = (IntTag)nbt;
        this.setEntropy(intTag.m_7047_());
    }
}

