/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.StargateVariantItem;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;

public abstract class AbstractStargateBaseBlock
extends AbstractStargateBlock
implements EntityBlock {
    public static final String EMPTY = StargateJourney.EMPTY;
    public static final String LOCAL_POINT_OF_ORIGIN = "LocalPointOfOrigin";

    public AbstractStargateBaseBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties, width, horizontalOffset);
    }

    public abstract AbstractStargateRingBlock getRing();

    public abstract AbstractShieldingBlock getIris();

    public boolean setVariant(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof StargateVariantItem) {
            if (!stack.m_41782_()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (!stargate.hasPermissions(player, true)) {
                        return false;
                    }
                    if (stargate.getVariant().equals((Object)StargateJourney.EMPTY)) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.same_variant"), true);
                        return true;
                    }
                    stargate.setVariant(StargateJourney.EMPTY_LOCATION);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return true;
            }
            ResourceLocation variant = StargateVariantItem.getVariant(stack);
            if (variant != null) {
                if (level.m_5776_()) {
                    return true;
                }
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (!stargate.hasPermissions(player, true)) {
                        return false;
                    }
                    if (variant.equals((Object)stargate.getVariant())) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.same_variant"), true);
                        return true;
                    }
                    RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
                    Registry variantRegistry = registries.m_175515_(StargateVariant.REGISTRY_KEY);
                    Optional<StargateVariant> stargateVariant = Optional.ofNullable((StargateVariant)variantRegistry.m_7745_(variant));
                    if (stargateVariant.isPresent() && !stargateVariant.get().getBaseStargate().equals((Object)BlockEntityType.m_58954_((BlockEntityType)stargate.m_58903_()))) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.incorrect_stargate_type"), true);
                        return true;
                    }
                    stargate.setVariant(variant);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return true;
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.invalid_variant"), true);
                return true;
            }
        }
        return false;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_21120_(hand).m_150930_((Item)ItemInit.STARGATE_VARIANT_CRYSTAL.get())) {
            return this.setVariant(level, pos, player, hand) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Player player = context.m_43723_();
        Orientation orientation = Orientation.getOrientationFromXRot(player);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)ORIENTATION, (Comparable)((Object)orientation));
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public abstract BlockState ringState();

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        for (StargatePart part : this.getParts()) {
            if (part.equals(StargatePart.BASE)) continue;
            level.m_7731_(part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION))), (BlockState)((BlockState)((BlockState)((BlockState)this.ringState().m_61124_((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).m_61124_((Property)AbstractStargateRingBlock.FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)FACING)))).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)((Orientation)((Object)level.m_8055_(pos).m_61143_((Property)ORIENTATION)))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION)))).m_76152_() == Fluids.f_76193_)), 3);
        }
        AbstractStargateEntity stargate = this.getStargate((BlockGetter)level, pos, state);
        if (stargate != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            this.updateIris(level, pos, state, irisStargate.irisInfo().getShieldingState());
        }
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
                stargate.bypassDisconnectStargate(StargateInfo.Feedback.STARGATE_DESTROYED, false);
                stargate.dhdInfo().unsetDHD(true);
                stargate.removeStargateFromNetwork();
            }
            this.destroyStargate(level, pos, this.getParts(), this.getShieldingParts(), (Direction)oldState.m_61143_((Property)FACING), (Orientation)((Object)oldState.m_61143_((Property)ORIENTATION)), (StargatePart)((Object)oldState.m_61143_((Property)PART)));
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    public void updateStargate(Level level, BlockPos pos, BlockState state, ShieldingState shieldingState) {
        if (!(state.m_60734_() instanceof AbstractStargateBlock)) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.m_61143_((Property)ORIENTATION));
        for (StargatePart part : this.getParts(shieldingState != ShieldingState.OPEN)) {
            BlockPos ringPos;
            if (part.equals(StargatePart.BASE) || !(level.m_8055_(ringPos = part.getRingPos(pos, direction, orientation)).m_60734_() instanceof AbstractStargateBlock)) continue;
            level.m_7731_(part.getRingPos(pos, direction, orientation), (BlockState)((BlockState)((BlockState)((BlockState)this.ringState().m_61124_((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).m_61124_((Property)AbstractStargateRingBlock.FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)FACING)))).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)((Orientation)((Object)level.m_8055_(pos).m_61143_((Property)ORIENTATION)))))).m_61124_((Property)AbstractStargateRingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION)))).m_76152_() == Fluids.f_76193_)), 3);
        }
    }

    public void unsetIris(BlockState state, Level level, BlockPos pos) {
        AbstractStargateEntity stargate = this.getStargate((BlockGetter)level, pos, state);
        if (stargate != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            irisStargate.irisInfo().removeIris();
        }
        this.updateStargate(level, pos, state, ShieldingState.OPEN);
    }

    public void updateIris(Level level, BlockPos pos, BlockState state, ShieldingState shieldingState) {
        if (this.getIris() == null) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.m_61143_((Property)ORIENTATION));
        AbstractShieldingBlock.setIrisState(this.getIris(), level, pos, this.getShieldingParts(), direction, orientation, shieldingState);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag blockEntityTag;
        long energy = 0L;
        String id = "";
        if (stack.m_41782_()) {
            String variant;
            blockEntityTag = stack.m_41783_().m_128469_("BlockEntityTag");
            if (blockEntityTag.m_128441_("Variant") && !(variant = blockEntityTag.m_128461_("Variant")).equals(EMPTY)) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.variant").m_7220_((Component)Component.m_237113_((String)(": " + variant))).m_130940_(ChatFormatting.GREEN));
            }
            if (blockEntityTag.m_128441_("Energy")) {
                energy = blockEntityTag.m_128454_("Energy");
            }
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + energy + " FE"))).m_130940_(ChatFormatting.DARK_RED));
        if (stack.m_41782_()) {
            blockEntityTag = stack.m_41783_().m_128469_("BlockEntityTag");
            if (blockEntityTag.m_128441_("DisplayID") && blockEntityTag.m_128471_("DisplayID") || ((Boolean)CommonStargateConfig.always_display_stargate_id.get()).booleanValue()) {
                if (blockEntityTag.m_128441_("ID")) {
                    id = blockEntityTag.m_128461_("ID");
                    tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.9_chevron_address").m_7220_((Component)Component.m_237113_((String)(": " + id))).m_130940_(ChatFormatting.AQUA));
                } else if (blockEntityTag.m_128441_("9ChevronAddress")) {
                    id = new Address(blockEntityTag.m_128465_("9ChevronAddress")).toString();
                    tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.9_chevron_address").m_7220_((Component)Component.m_237113_((String)(": " + id))).m_130940_(ChatFormatting.AQUA));
                }
            }
            if (blockEntityTag.m_128441_("Upgraded") && blockEntityTag.m_128471_("Upgraded")) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.upgraded").m_130940_(ChatFormatting.DARK_GREEN));
            }
            if (blockEntityTag.m_128441_(LOCAL_POINT_OF_ORIGIN)) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.local_point_of_origin").m_130940_(ChatFormatting.GREEN));
            }
        }
        if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128425_("generation_step", 1) && StructureGenEntity.Step.SETUP == StructureGenEntity.Step.fromByte(stack.m_41783_().m_128469_("BlockEntityTag").m_128445_("generation_step"))) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.generates_inside_structure").m_130940_(ChatFormatting.YELLOW));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128471_("primary")) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.is_primary").m_130940_(ChatFormatting.DARK_GREEN));
        }
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    public static ItemStack excludeFromNetwork(ItemStack stack) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128344_("generation_step", StructureGenEntity.Step.SETUP.byteValue());
        stack.m_41700_("BlockEntityTag", (Tag)compoundtag);
        return stack;
    }

    public static ItemStack localPointOfOrigin(ItemStack stack) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128379_(LOCAL_POINT_OF_ORIGIN, true);
        stack.m_41700_("BlockEntityTag", (Tag)compoundtag);
        return stack;
    }

    @Override
    public AbstractStargateEntity getStargate(BlockGetter reader, BlockPos pos, BlockState state) {
        BlockEntity blockentity = reader.m_7702_(pos);
        if (blockentity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
            return stargate;
        }
        return null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typeA, BlockEntityType<E> typeB, BlockEntityTicker<? super E> ticker) {
        return typeB == typeA ? ticker : null;
    }
}

