/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransporterEntity
extends EnergyBlockEntity
implements StructureGenEntity,
Nameable {
    protected static final boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    public static final String ID = "ID";
    public static final String CUSTOM_NAME = "CustomName";
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    protected UUID id;
    protected String connectionID = StargateJourney.EMPTY;
    @Nullable
    private Component name;

    public AbstractTransporterEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.m_128445_("generation_step"));
        }
        try {
            if (tag.m_128441_(ID)) {
                this.id = UUID.fromString(tag.m_128461_(ID));
            }
        }
        catch (IllegalArgumentException e) {
            this.setID(this.generateID());
        }
        if (tag.m_128425_(CUSTOM_NAME, 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_(CUSTOM_NAME));
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.m_128344_("generation_step", this.generationStep.byteValue());
        }
        if (this.id != null) {
            tag.m_128359_(ID, this.id.toString());
        }
        super.m_183515_(tag);
        if (this.name != null) {
            tag.m_128359_(CUSTOM_NAME, Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public UUID generateID() {
        return UUID.randomUUID();
    }

    public void setID(UUID id) {
        this.id = id;
        this.m_6596_();
        StargateJourney.LOGGER.info("Set ID to " + id);
    }

    public UUID getID() {
        return this.id;
    }

    public void addTransporterToNetwork() {
        if (this.id == null) {
            this.setID(this.generateID());
        }
        TransporterNetwork.get(this.f_58857_).addTransporter(this);
        this.m_6596_();
    }

    public void removeTransporterFromNetwork() {
        TransporterNetwork.get(this.f_58857_).removeTransporter(this.f_58857_, this.id);
    }

    @Override
    public void getStatus(Player player) {
        super.getStatus(player);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        player.m_213846_((Component)Component.m_237113_((String)("ID: " + this.id)).m_130940_(ChatFormatting.AQUA));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.add_to_network").m_7220_((Component)Component.m_237113_((String)(": " + (this.generationStep == StructureGenEntity.Step.GENERATED)))).m_130940_(ChatFormatting.YELLOW));
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    protected abstract Component getDefaultName();

    public abstract boolean isConnected();

    public int getTimeOffset() {
        return 0;
    }

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    public void generate() {
        this.addTransporterToNetwork();
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }
}

