/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import org.jetbrains.annotations.NotNull;

public abstract class EnergyBlockEntity
extends BlockEntity {
    public static final String ENERGY = "Energy";
    private boolean canGenerateEnergy;
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    public final SGJourneyEnergy ENERGY_STORAGE = new SGJourneyEnergy(this.capacity(), this.maxReceive(), this.maxExtract()){

        @Override
        public boolean canExtract() {
            return EnergyBlockEntity.this.outputsEnergy();
        }

        @Override
        public boolean canReceive() {
            return EnergyBlockEntity.this.receivesEnergy();
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            EnergyBlockEntity.this.changeEnergy(difference, simulate);
        }
    };

    public EnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, boolean canGenerateEnergy) {
        super(type, pos, state);
        this.canGenerateEnergy = canGenerateEnergy;
    }

    public EnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, false);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        this.lazyEnergyHandler.invalidate();
        super.invalidateCaps();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.ENERGY_STORAGE.setEnergy(nbt.m_128454_(ENERGY));
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_(ENERGY, this.ENERGY_STORAGE.getTrueEnergyStored());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.ENERGY && this.isCorrectEnergySide(side)) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    protected boolean isCorrectEnergySide(Direction side) {
        return true;
    }

    protected boolean outputsEnergy() {
        return this.getMaxExtract() > 0L;
    }

    protected boolean receivesEnergy() {
        return this.getMaxReceive() > 0L;
    }

    protected abstract long capacity();

    protected abstract long maxReceive();

    protected abstract long maxExtract();

    protected void changeEnergy(long difference, boolean simulate) {
        this.m_6596_();
    }

    public long depleteEnergy(long amount, boolean simulate) {
        long storedEnergy = this.getEnergyStored();
        long maxEnergyDepletion = Math.min(amount, this.maxExtract());
        long energyDepleted = Math.min(storedEnergy, maxEnergyDepletion);
        if (!simulate) {
            this.setEnergy(storedEnergy - energyDepleted);
        }
        if (energyDepleted != 0L) {
            this.ENERGY_STORAGE.onEnergyChanged(energyDepleted, simulate);
        }
        return energyDepleted;
    }

    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getTrueEnergyStored();
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        return this.ENERGY_STORAGE.extractLongEnergy(maxExtract, simulate);
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        return this.ENERGY_STORAGE.receiveLongEnergy(maxReceive, simulate);
    }

    public long setEnergy(long energy) {
        return this.ENERGY_STORAGE.setEnergy(energy);
    }

    public boolean canExtract() {
        return this.ENERGY_STORAGE.canExtract();
    }

    public boolean canExtractEnergy(long energy) {
        if (this.ENERGY_STORAGE.getTrueMaxEnergyStored() < energy) {
            return false;
        }
        if (this.ENERGY_STORAGE.maxExtract() < energy) {
            return false;
        }
        return this.ENERGY_STORAGE.getTrueEnergyStored() >= energy;
    }

    public boolean canReceive() {
        return this.ENERGY_STORAGE.canReceive();
    }

    public long getEnergyCapacity() {
        return this.ENERGY_STORAGE.getTrueMaxEnergyStored();
    }

    public long getMaxExtract() {
        return this.ENERGY_STORAGE.maxExtract();
    }

    public long getMaxReceive() {
        return this.ENERGY_STORAGE.maxReceive();
    }

    protected void generateEnergy(long energyGenerated) {
        if (!this.canGenerateEnergy) {
            return;
        }
        long moreEnergy = this.getEnergyStored() + energyGenerated;
        if (this.capacity() >= moreEnergy) {
            this.ENERGY_STORAGE.setEnergy(moreEnergy);
        }
    }

    public boolean canReceive(long receivedEnergy) {
        return this.ENERGY_STORAGE.canReceive(receivedEnergy);
    }

    protected void outputEnergy(Direction outputDirection) {
        if (outputDirection == null) {
            return;
        }
        if (this.ENERGY_STORAGE.canExtract()) {
            BlockEntity blockentity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(outputDirection));
            if (blockentity == null) {
                return;
            }
            if (blockentity instanceof EnergyBlockEntity) {
                EnergyBlockEntity energyBE = (EnergyBlockEntity)blockentity;
                long simulatedOutputAmount = this.extractEnergy(this.maxExtract(), true);
                long simulatedReceiveAmount = energyBE.receiveEnergy(simulatedOutputAmount, true);
                this.extractEnergy(simulatedReceiveAmount, false);
                energyBE.receiveEnergy(simulatedReceiveAmount, false);
            } else {
                blockentity.getCapability(ForgeCapabilities.ENERGY, outputDirection).ifPresent(energyStorage -> {
                    int simulatedOutputAmount = this.ENERGY_STORAGE.extractEnergy(SGJourneyEnergy.getRegularEnergy(this.ENERGY_STORAGE.maxExtract()), true);
                    int simulatedReceiveAmount = energyStorage.receiveEnergy(simulatedOutputAmount, true);
                    this.ENERGY_STORAGE.extractEnergy(simulatedReceiveAmount, false);
                    energyStorage.receiveEnergy(simulatedReceiveAmount, false);
                });
            }
        }
    }

    public void getStatus(Player player) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + this.getEnergyStored() + " FE"))).m_130940_(ChatFormatting.DARK_RED));
    }
}

