/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.base.CaseFormat;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBuiltInDataProvider<T>
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final ResourceKey<? extends Registry<T>> registryKey;
    private BootstapContext<T> bootstapContext;

    public AbstractBuiltInDataProvider(ResourceKey<? extends Registry<T>> registryKey, DataProviderContext context) {
        this(registryKey, context.getModId(), context.getPackOutput(), context.getLookupProvider());
    }

    public AbstractBuiltInDataProvider(ResourceKey<? extends Registry<T>> registryKey, String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.registryKey = registryKey;
        this.output = output;
        this.modId = modId;
        this.lookupProvider = lookupProvider;
    }

    protected final void add(ResourceKey<T> key, T value) {
        this.bootstapContext.m_255272_(key, value);
    }

    protected abstract void addBootstrap(BootstapContext<T> var1);

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        return new DatapackBuiltinEntriesProvider(this.output, this.lookupProvider, new RegistrySetBuilder().m_254916_(this.registryKey, context -> {
            this.bootstapContext = context;
            this.addBootstrap(context);
        }), Set.of(this.modId)).m_213708_(output);
    }

    public String m_6055_() {
        String name = this.registryKey.m_135782_().m_135815_().replaceAll("\\W", "_");
        name = (String)CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)name);
        name = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)name), (char)' ');
        return name + " Built In Data";
    }

    public static abstract class TrimMaterials
    extends AbstractBuiltInDataProvider<TrimMaterial> {
        public TrimMaterials(DataProviderContext context) {
            super(Registries.f_266076_, context);
        }

        public TrimMaterials(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(Registries.f_266076_, modId, output, lookupProvider);
        }

        protected void add(ResourceKey<TrimMaterial> resourceKey, Item ingredient, int descriptionColor, float itemModelIndex) {
            this.add(resourceKey, ingredient, descriptionColor, itemModelIndex, Collections.emptyMap());
        }

        protected void add(ResourceKey<TrimMaterial> resourceKey, Item ingredient, int descriptionColor, float itemModelIndex, Map<ArmorMaterials, String> overrideArmorMaterials) {
            MutableComponent description = Component.m_237115_((String)Util.m_137492_((String)"trim_material", (ResourceLocation)resourceKey.m_135782_())).m_130948_(Style.f_131099_.m_178520_(descriptionColor));
            TrimMaterial trimMaterial = TrimMaterial.m_267605_((String)resourceKey.m_135782_().m_135815_(), (Item)ingredient, (float)itemModelIndex, (Component)description, overrideArmorMaterials);
            this.add(resourceKey, trimMaterial);
        }
    }

    public static abstract class DamageTypes
    extends AbstractBuiltInDataProvider<DamageType> {
        public DamageTypes(DataProviderContext context) {
            super(Registries.f_268580_, context);
        }

        public DamageTypes(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(Registries.f_268580_, modId, output, lookupProvider);
        }

        protected void add(ResourceKey<DamageType> resourceKey) {
            this.add(resourceKey, new DamageType(resourceKey.m_135782_().m_135815_(), 0.1f));
        }

        @Override
        protected void add(ResourceKey<DamageType> resourceKey, DamageEffects damageEffects) {
            this.add(resourceKey, new DamageType(resourceKey.m_135782_().m_135815_(), 0.1f, damageEffects));
        }
    }
}

