/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import javax.annotation.Nullable;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IPropagationHooks;
import mrtjp.projectred.core.part.IPropagationPart;
import mrtjp.projectred.transmission.part.IBundledCablePart;
import mrtjp.projectred.transmission.part.IInsulatedRedwirePart;

public interface IBundledPropagationPart
extends IPropagationPart,
IPropagationHooks {
    public byte[] getSignal();

    public void setSignal(@Nullable byte[] var1);

    public int getColorMask();

    public void setColorMask(int var1);

    public byte[] calculateSignal();

    default public void updateAndPropagate(@Nullable IPropagationPart from, int mode) {
        int mask = this.getColorMaskFrom(from, mode);
        if (mode == 1 && BundledSignalsLib.isSignalZero((byte[])this.getSignal(), (int)mask)) {
            return;
        }
        byte[] newSignal = this.calculateSignal();
        BundledSignalsLib.applyChangeMask((byte[])this.getSignal(), (byte[])newSignal, (int)mask);
        this.setColorMask(mask);
        if (BundledSignalsLib.dropSignalsLessThan((byte[])this.getSignal(), (byte[])newSignal)) {
            if (!BundledSignalsLib.isSignalZero((byte[])newSignal, (int)mask)) {
                RedstonePropagator.propagateAnalogDrop((IPropagationPart)this);
            }
            this.propagateForward(from, 1);
        } else if (!BundledSignalsLib.signalsEqual((byte[])this.getSignal(), (byte[])newSignal)) {
            this.setSignal(newSignal);
            if (mode == 1) {
                this.propagateForward(null, 0);
            } else {
                this.propagateForward(from, 0);
            }
        } else if (mode == 2) {
            this.propagateForward(from, 3);
        } else if (mode == 1) {
            this.propagateBackward(from, 0);
        }
        this.setColorMask(65535);
    }

    default public int getColorMaskFrom(@Nullable IPropagationPart from, int mode) {
        if (from instanceof IInsulatedRedwirePart) {
            return 1 << ((IInsulatedRedwirePart)from).getInsulatedColour();
        }
        if (from instanceof IBundledCablePart && mode == 1) {
            int m = 0;
            byte[] signalIn = ((IBundledCablePart)from).getBundledSignal();
            for (int i = 0; i < 16; ++i) {
                if (signalIn[i] != 0) continue;
                m |= 1 << i;
            }
            return m;
        }
        if (from instanceof IBundledCablePart && mode == 0) {
            int m = 0;
            byte[] signalIn = ((IBundledCablePart)from).getBundledSignal();
            for (int i = 0; i < 16; ++i) {
                if ((signalIn[i] & 0xFF) <= (this.getSignal()[i] & 0xFF)) continue;
                m |= 1 << i;
            }
            return m;
        }
        return 65535;
    }

    default public boolean shouldPropagate(@Nullable IPropagationPart to, int mode) {
        if (to instanceof IInsulatedRedwirePart) {
            int insColour = ((IInsulatedRedwirePart)to).getInsulatedColour();
            return (this.getColorMask() & 1 << insColour) != 0;
        }
        return true;
    }
}

