/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.data;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.lib.util.CCLTags;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.init.CoreTags;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.init.TransmissionTags;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class TransmissionRecipeProvider
extends RecipeProvider {
    public TransmissionRecipeProvider(PackOutput output) {
        super(output, "projectred_transmission");
    }

    protected void registerRecipes() {
        int i;
        Item w;
        this.shapedRecipe((ItemLike)WireType.RED_ALLOY.getItem(), 12).key('R', CoreTags.RED_ALLOY_INGOT_TAG).patternLine(" R ").patternLine(" R ").patternLine(" R ");
        for (WireType type : WireType.INSULATED_WIRES) {
            w = type.getItem();
            this.shapedRecipe((ItemLike)w, 12).key('W', this.getWoolTag(type.getColour())).key('R', CoreTags.RED_ALLOY_INGOT_TAG).patternLine("WRW").patternLine("WRW").patternLine("WRW");
            this.shapelessRecipe((ItemLike)w, 1, new ResourceLocation(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)w)) + "_re_color")).addIngredient(TransmissionTags.INSULATED_WIRE_ITEM_TAG).addIngredient(this.getDyeTag(type.getColour()));
        }
        this.shapedRecipe((ItemLike)WireType.BUNDLED_NEUTRAL.getItem()).key('S', Tags.Items.STRING).key('W', TransmissionTags.INSULATED_WIRE_ITEM_TAG).patternLine("SWS").patternLine("WWW").patternLine("SWS");
        for (WireType type : WireType.COLOURED_BUNDLED_WIRES) {
            w = type.getItem();
            this.shapelessRecipe((ItemLike)w, 1, new ResourceLocation(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)w)) + "_re_color")).addIngredient(TransmissionTags.BUNDLED_WIRE_ITEM_TAG).addIngredient(this.getDyeTag(type.getColour()));
        }
        this.shapedRecipe((ItemLike)WireType.POWER_LOWLOAD.getItem(), 12).key('I', CoreTags.ELECTROTINE_ALLOY_INGOT_TAG).key('B', CCLTags.Items.WOOL_BLUE).key('Y', CCLTags.Items.WOOL_YELLOW).patternLine("BIB").patternLine("YIY").patternLine("BIB");
        this.framedWireRecipe(WireType.FRAMED_RED_ALLOY.getItem(), WireType.RED_ALLOY.getItem());
        for (i = 0; i < 16; ++i) {
            WireType type = WireType.FRAMED_INSULATED_WIRES[i];
            Item w2 = type.getItem();
            this.framedWireRecipe(w2, WireType.INSULATED_WIRES[i].getItem());
            this.shapelessRecipe((ItemLike)w2, 1, new ResourceLocation(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)w2)) + "_re_color")).addIngredient(TransmissionTags.FRAMED_INSULATED_WIRE_ITEM_TAG).addIngredient(this.getDyeTag(type.getColour()));
        }
        this.framedWireRecipe(WireType.FRAMED_BUNDLED_NEUTRAL.getItem(), WireType.BUNDLED_NEUTRAL.getItem());
        for (i = 0; i < 16; ++i) {
            WireType type = WireType.FRAMED_COLOURED_BUNDLED_WIRES[i];
            Item w3 = type.getItem();
            this.framedWireRecipe(w3, WireType.COLOURED_BUNDLED_WIRES[i].getItem());
            this.shapelessRecipe((ItemLike)w3, 1, new ResourceLocation(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)w3)) + "_re_color")).addIngredient(TransmissionTags.FRAMED_BUNDLED_WIRE_ITEM_TAG).addIngredient(this.getDyeTag(type.getColour()));
        }
        this.framedWireRecipe(WireType.FRAMED_POWER_LOWLOAD.getItem(), WireType.POWER_LOWLOAD.getItem());
        this.shapedRecipe((ItemLike)CoreItems.WIRED_PLATE_ITEM.get(), 1, new ResourceLocation("projectred_transmission", ForgeRegistries.ITEMS.getKey((Object)((Item)CoreItems.WIRED_PLATE_ITEM.get())).m_135815_())).key('W', (ItemLike)WireType.RED_ALLOY.getItem()).key('P', (ItemLike)CoreItems.PLATE_ITEM.get()).patternLine("W").patternLine("P");
        this.shapedRecipe((ItemLike)CoreItems.BUNDLED_PLATE_ITEM.get(), 1, new ResourceLocation("projectred_transmission", ForgeRegistries.ITEMS.getKey((Object)((Item)CoreItems.BUNDLED_PLATE_ITEM.get())).m_135815_())).key('W', TransmissionTags.BUNDLED_WIRE_ITEM_TAG).key('P', (ItemLike)CoreItems.PLATE_ITEM.get()).patternLine("W").patternLine("P");
    }

    private void framedWireRecipe(Item result, Item input) {
        this.shapedRecipe((ItemLike)result).key('S', Tags.Items.RODS_WOODEN).key('I', (ItemLike)input).patternLine("SSS").patternLine("SIS").patternLine("SSS");
    }

    private TagKey<Item> getWoolTag(EnumColour colour) {
        return ItemTags.create((ResourceLocation)colour.getWoolTagName());
    }

    private TagKey<Item> getDyeTag(EnumColour colour) {
        return ItemTags.create((ResourceLocation)colour.getDyeTagName());
    }
}

