/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVScale;
import codechicken.lib.vec.uv.UVTransformation;
import codechicken.lib.vec.uv.UVTranslation;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.UVT;
import mrtjp.projectred.transmission.client.WireModelBuilder;

public class FramedWireModelBuilder {
    private static final UVTransformation ROTATE_WIRE_UV_180 = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 16.0)));
    private int connMap = 0;
    private int tw = 0;
    private double w = 0.0;
    private int connCount = 0;
    private int axisCount = 0;
    private final int[] fRotationMasks = new int[6];
    private final int[] fAxisCounts = new int[6];
    private int i = 0;
    @Nullable
    private CCModel model = null;
    private int modelKey = 0;
    private boolean modelBuilt = false;

    public FramedWireModelBuilder setModelKey(int key) {
        this.modelKey = key;
        return this;
    }

    public CCModel build() {
        if (!this.modelBuilt) {
            this.buildModel();
            this.modelBuilt = true;
            assert (this.model != null);
            return this.model;
        }
        assert (this.model != null);
        return this.model.copy();
    }

    private void buildModel() {
        int s;
        this.connMap = this.modelKey & 0x3F;
        this.connCount = FramedWireModelBuilder.countConnections(this.connMap);
        this.axisCount = FramedWireModelBuilder.countAxis(this.connMap);
        for (int s2 = 0; s2 < 6; ++s2) {
            this.fRotationMasks[s2] = FramedWireModelBuilder.calcFaceRotationMask(this.connMap, s2);
            this.fAxisCounts[s2] = FramedWireModelBuilder.countFaceAxis(this.fRotationMasks[s2]);
        }
        int thickness = this.modelKey >> 6;
        this.tw = thickness + 1;
        this.w = (double)this.tw / 16.0 + 0.004;
        this.i = 0;
        int axisVertCount = this.axisCount * 16;
        int capVertCount = this.connCount * 4;
        int stubVertCount = 0;
        int circleVertCount = 0;
        for (s = 0; s < 6; ++s) {
            if (this.fAxisCounts[s] == 0) {
                stubVertCount += 4;
            }
            if (this.fAxisCounts[s] != 2) continue;
            circleVertCount += 4;
        }
        this.model = CCModel.quadModel((int)(axisVertCount + stubVertCount + circleVertCount + capVertCount));
        for (s = 0; s < 6; ++s) {
            this.generateFace(s);
        }
        WireModelBuilder.finishModel(this.model);
    }

    private void generateFace(int s) {
        int start = this.i;
        this.i = WireModelBuilder.addVerts(Objects.requireNonNull(this.model), this.generateFaceAxisVerts(s), this.i);
        switch (this.fAxisCounts[s]) {
            case 0: {
                this.i = WireModelBuilder.addVerts(this.model, this.generateFaceStubVerts(s, 0.5 - this.w), this.i);
                break;
            }
            case 2: {
                this.i = WireModelBuilder.addVerts(this.model, this.generateFaceCircleVerts(s), this.i);
                break;
            }
        }
        if ((this.connMap & 1 << (s ^ 1)) != 0) {
            this.i = WireModelBuilder.addVerts(this.model, this.generateFaceStubVerts(s, 0.0), this.i);
        }
        Transformation t = Rotation.sideOrientation((int)s, (int)0).at(Vector3.CENTER);
        WireModelBuilder.apply(t, this.model, start, this.i);
    }

    private Vertex5[] generateFaceAxisVerts(int s) {
        Vertex5[] aVerts;
        double d = 0.5 - this.w;
        int numAxis = this.fAxisCounts[s];
        int fMask = this.fRotationMasks[s];
        Vertex5[] verts = new Vertex5[numAxis * 4];
        int vi = 0;
        if ((fMask & 5) != 0) {
            aVerts = this.axisVerts(fMask, d);
            this.reflectSide(aVerts, s, 0);
            System.arraycopy(aVerts, 0, verts, vi, 4);
            vi += 4;
        }
        if ((fMask & 0xA) != 0) {
            aVerts = this.axisVerts(fMask >> 1, d);
            this.reflectSide(aVerts, s, 1);
            Transformation t = Rotation.quarterRotations[1].at(Vector3.CENTER);
            WireModelBuilder.apply(t, aVerts);
            System.arraycopy(aVerts, 0, verts, vi, 4);
            vi += 4;
        }
        return verts;
    }

    private Vertex5[] axisVerts(int mask, double d) {
        int tl = 8 - this.tw;
        double l = (double)tl / 16.0 + 0.004;
        double zn = (mask & 1) != 0 ? l : 0.0;
        double vn = (mask & 1) != 0 ? (double)tl : 0.0;
        double zp = (mask & 4) != 0 ? l : 0.0;
        double vp = (mask & 4) != 0 ? (double)tl : 0.0;
        return new Vertex5[]{new Vertex5(0.5 - this.w, 1.0 - d, 0.5 + this.w + zp, (double)(8 - this.tw), (double)(16 + this.tw) + vp), new Vertex5(0.5 + this.w, 1.0 - d, 0.5 + this.w + zp, (double)(8 + this.tw), (double)(16 + this.tw) + vp), new Vertex5(0.5 + this.w, 1.0 - d, 0.5 - this.w - zn, (double)(8 + this.tw), (double)(16 - this.tw) - vn), new Vertex5(0.5 - this.w, 1.0 - d, 0.5 - this.w - zn, (double)(8 - this.tw), (double)(16 - this.tw) - vn)};
    }

    private Vertex5[] generateFaceStubVerts(int s, double d) {
        Vertex5[] aVerts = this.axisVerts(0, d);
        UVTranslation t = new UVTranslation(12.0, 12.0);
        WireModelBuilder.apply((UVTransformation)t, aVerts);
        if (s % 2 == 1) {
            UVTransformation ft = new UVScale(-1.0, 1.0).at(new UV(20.0, 28.0));
            WireModelBuilder.apply(ft, aVerts);
        }
        return aVerts;
    }

    private Vertex5[] generateFaceCircleVerts(int s) {
        double d = 0.5 - this.w;
        Vertex5[] aVerts = this.axisVerts(0, d - 0.002);
        this.rotateSide(aVerts, s);
        UVTranslation t = new UVTranslation(16.0, 0.0);
        WireModelBuilder.apply((UVTransformation)t, aVerts);
        return aVerts;
    }

    public static int countConnections(int connMask) {
        int count = 0;
        for (int s = 0; s < 6; ++s) {
            if ((connMask & 1 << s) == 0) continue;
            ++count;
        }
        return count;
    }

    public static int countAxis(int connMask) {
        int count = 0;
        for (int a = 0; a < 3; ++a) {
            if ((connMask & 3 << a * 2) == 0) continue;
            ++count;
        }
        return count;
    }

    public static int calcFaceRotationMask(int connMap, int s) {
        int rMask = 0;
        for (int r = 0; r < 4; ++r) {
            int absSide = Rotation.rotateSide((int)s, (int)((r + 2) % 4));
            if ((connMap & 1 << absSide) == 0) continue;
            rMask |= 1 << r;
        }
        return rMask;
    }

    public static int countFaceAxis(int faceRotMask) {
        int a = 0;
        if ((faceRotMask & 5) != 0) {
            ++a;
        }
        if ((faceRotMask & 0xA) != 0) {
            ++a;
        }
        return a;
    }

    private void reflectSide(Vertex5[] verts, int s, int r) {
        if ((r + BundledSignalsLib.bundledCableBaseRotationMap[s]) % 4 >= 2) {
            WireModelBuilder.apply(ROTATE_WIRE_UV_180, verts);
        }
    }

    private void rotateSide(Vertex5[] verts, int s) {
        int r = BundledSignalsLib.bundledCableBaseRotationMap[s];
        UVT uvt = new UVT(Rotation.quarterRotations[r % 4].at(new Vector3(8.0, 0.0, 16.0)));
        WireModelBuilder.apply((UVTransformation)uvt, verts);
    }
}

