/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.api.part.AnimateTickPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.init.CBMultipartModContent;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.RedstoneFaceLookup;
import mrtjp.projectred.core.part.IRedwireEmitter;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.client.GateModelRenderer;
import mrtjp.projectred.integration.part.GatePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public abstract class RedstoneGatePart
extends GatePart
implements FaceRedstonePart,
AnimateTickPart {
    public static final int KEY_STATE = 10;
    private byte gateState = 0;

    public RedstoneGatePart(GateType type) {
        super(type);
    }

    public int getState() {
        return this.gateState & 0xFF;
    }

    public void setState(int gateState) {
        this.gateState = (byte)gateState;
    }

    @Override
    public int state() {
        return this.gateState & 0xFF;
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("state", this.gateState);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.gateState = tag.m_128445_("state");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.gateState);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.gateState = packet.readByte();
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 10: {
                this.gateState = packet.readByte();
                if (!Configurator.staticGates) break;
                this.tile().markRender();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendStateUpdate() {
        this.sendUpdate(10, p -> p.writeByte((int)this.gateState));
    }

    public void notifyExternals(int mask) {
        int smask = 0;
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) == 0) continue;
            int absSide = this.absoluteDir(r);
            BlockPos pos2 = this.pos().m_121945_(Direction.values()[absSide]);
            this.level().m_46586_(pos2, (Block)CBMultipartModContent.MULTIPART_BLOCK.get(), this.pos());
            for (int s = 0; s < 6; ++s) {
                if (s == (absSide ^ 1) || (smask & 1 << s) != 0) continue;
                this.level().m_46586_(pos2.m_121945_(Direction.values()[s]), (Block)CBMultipartModContent.MULTIPART_BLOCK.get(), pos2);
            }
            smask |= 1 << absSide;
        }
    }

    public int getFace() {
        return this.getSide();
    }

    public int strongPowerLevel(int side) {
        if ((side & 6) == (this.getSide() & 6)) {
            return 0;
        }
        int ir = this.toInternal(this.absoluteRot(side));
        return (this.outputMask(this.shape()) & 1 << ir) != 0 ? this.getOutput(ir) : 0;
    }

    public int weakPowerLevel(int side) {
        return this.strongPowerLevel(side);
    }

    public boolean canConnectRedstone(int side) {
        if ((side & 6) == (this.getSide() & 6)) {
            return false;
        }
        return this.gateLogicCanConnect(this.toInternal(this.absoluteRot(side)));
    }

    protected int getRedstoneInput(int r) {
        int ar = this.toAbsolute(r);
        FaceLookup lookup = null;
        if (this.maskConnectsCorner(ar)) {
            lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)ar);
        } else if (this.maskConnectsStraight(ar)) {
            lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)ar);
        } else if (this.maskConnectsInside(ar)) {
            lookup = FaceLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)ar);
        }
        if (lookup != null) {
            return RedstoneFaceLookup.resolveSignal((FaceLookup)lookup, (boolean)false);
        }
        lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)ar);
        return RedstoneFaceLookup.resolveVanillaSignal((FaceLookup)lookup, (MultiPart)this, (boolean)true, (boolean)false);
    }

    protected int getAnalogRedstoneInput(int r) {
        return (this.getRedstoneInput(r) + 16) / 17;
    }

    protected void onInputChange() {
        this.tile().m_6596_();
        this.sendStateUpdate();
    }

    protected void onOutputChange(int mask) {
        this.tile().m_6596_();
        this.sendStateUpdate();
        this.tile().internalPartChange((MultiPart)this);
        this.notifyExternals(this.toAbsoluteMask(mask));
    }

    protected void tickSound() {
        if (Configurator.logicGateSounds) {
            this.level().m_5594_(null, this.pos(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.15f, 0.5f);
        }
    }

    @Override
    protected boolean gateLogicCanConnectTo(IConnectable part, int r) {
        if (part instanceof IRedwireEmitter) {
            return this.gateLogicCanConnect(r);
        }
        return false;
    }

    protected boolean gateLogicCanConnect(int r) {
        int ioMask = this.outputMask(this.shape()) | this.inputMask(this.shape());
        return (ioMask & 1 << r) != 0;
    }

    protected int outputMask(int shape) {
        return 0;
    }

    protected int inputMask(int shape) {
        return 0;
    }

    protected int getOutput(int r) {
        return (this.getState() & 16 << r) != 0 ? 15 : 0;
    }

    protected int getInput(int mask) {
        int input = 0;
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) == 0 || this.getRedstoneInput(r) <= 0) continue;
            input |= 1 << r;
        }
        return input;
    }

    public void animateTick(RandomSource random) {
        GateModelRenderer.instance().spawnParticles(this, random);
    }
}

