/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.inventory.container.PlottingTableMenu;
import mrtjp.projectred.fabrication.item.BlankPhotomaskItem;
import mrtjp.projectred.fabrication.item.ICBlueprintItem;
import mrtjp.projectred.fabrication.tile.FabricationMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class PlottingTableBlockEntity
extends FabricationMachineBlockEntity {
    private final BaseContainer inventory = new BaseContainer(3){

        public boolean m_7013_(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_41720_() instanceof ICBlueprintItem;
                case 1 -> stack.m_41720_() instanceof BlankPhotomaskItem;
                default -> false;
            };
        }
    };

    public PlottingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FabricationBlocks.PLOTTING_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.inventory.m_19164_(this::onInventoryChanged);
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        this.inventory.saveTo(tag, "inventory");
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.inventory.loadFrom(tag, "inventory");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new PlottingTableMenu(inv, this, id), (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        PlottingTableBlockEntity.dropInventory((Container)this.inventory, (Level)this.m_58904_(), (Vector3)Vector3.fromBlockPos((BlockPos)this.m_58899_()));
    }

    private void onInventoryChanged(Container inventory) {
        this.cancelWorkIfNeeded();
        this.m_6596_();
    }

    @Override
    protected boolean canStartWork() {
        ItemStack slot0 = this.inventory.m_8020_(0);
        ItemStack slot1 = this.inventory.m_8020_(1);
        if (slot0.m_41619_() || slot1.m_41619_()) {
            return false;
        }
        if (!(slot0.m_41720_() instanceof ICBlueprintItem)) {
            return false;
        }
        if (!(slot1.m_41720_() instanceof BlankPhotomaskItem)) {
            return false;
        }
        if (!EditorDataUtils.canFabricate(slot0.m_41783_())) {
            return false;
        }
        return this.inventory.m_8020_(2).m_41619_();
    }

    @Override
    protected int startWork() {
        return 200;
    }

    @Override
    protected int tickWork(int remainingWork) {
        if (this.canConductorWork()) {
            this.conductor.applyPower(-100.0);
            return 1;
        }
        return 0;
    }

    @Override
    protected void finishWork() {
        ItemStack output = ICBlueprintItem.createPhotomaskStack(this.inventory.m_8020_(0));
        this.inventory.m_6836_(2, output);
        this.inventory.m_7407_(1, 1);
    }
}

