/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.gui.ICRenderNode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public class ICEditorToolManager
implements ICRenderNode.IICRenderNodeEventReceiver {
    private final Vector3 lastMousePosition = new Vector3();
    private final Vector3 initialLeftMousePosition = new Vector3();
    private final Vector3 initialRightMousePosition = new Vector3();
    private boolean leftMouseDown = false;
    private boolean rightMouseDown = false;
    private final ArrayList<IICEditorTool> toolList;
    private IICEditorTool selectedTool;
    private boolean upPressed = false;
    private boolean rightPressed = false;
    private boolean downPressed = false;
    private boolean leftPressed = false;
    private boolean layerUpPressed = false;
    private boolean layerDownPressed = false;
    private final List<Consumer<ICEditorToolType>> toolSwappedListeners = new LinkedList<Consumer<ICEditorToolType>>();

    public ICEditorToolManager(ArrayList<IICEditorTool> toolList) {
        this.toolList = toolList;
        this.selectedTool = toolList.get(0);
    }

    public void swapTools(ICEditorToolType nextToolType) {
        IICEditorTool nextTool = this.toolList.get(nextToolType.ordinal());
        if (nextTool != this.selectedTool) {
            this.selectedTool.toolDeactivated();
            this.selectedTool = nextTool;
            this.selectedTool.toolActivated();
            for (Consumer<ICEditorToolType> listener : this.toolSwappedListeners) {
                listener.accept(nextToolType);
            }
        }
    }

    public void addToolSwappedListener(Consumer<ICEditorToolType> listener) {
        this.toolSwappedListeners.add(listener);
    }

    public boolean keyPressed(int glfwKeyCode, int glfwFlags) {
        switch (glfwKeyCode) {
            case 256: {
                if (this.selectedTool.toolCanceled()) break;
                if (this.selectedTool.getToolType() != ICEditorToolType.INTERACT_TOOL) {
                    this.swapTools(ICEditorToolType.INTERACT_TOOL);
                    break;
                }
                return false;
            }
            case 87: {
                this.upPressed = true;
                break;
            }
            case 65: {
                this.leftPressed = true;
                break;
            }
            case 83: {
                this.downPressed = true;
                break;
            }
            case 68: {
                this.rightPressed = true;
                break;
            }
            case 265: {
                this.layerUpPressed = true;
                break;
            }
            case 264: {
                this.layerDownPressed = true;
                break;
            }
            default: {
                return this.selectedTool.toolKeyPressed(this.lastMousePosition, glfwKeyCode, glfwFlags);
            }
        }
        return true;
    }

    public boolean keyReleased(int glfwKeyCode, int glfwFlags) {
        switch (glfwKeyCode) {
            case 87: {
                this.upPressed = false;
                break;
            }
            case 65: {
                this.leftPressed = false;
                break;
            }
            case 83: {
                this.downPressed = false;
                break;
            }
            case 68: {
                this.rightPressed = false;
                break;
            }
            case 265: {
                this.layerUpPressed = false;
                break;
            }
            case 264: {
                this.layerDownPressed = false;
                break;
            }
            default: {
                return this.selectedTool.toolKeyReleased(this.lastMousePosition, glfwKeyCode, glfwFlags);
            }
        }
        return true;
    }

    @Override
    public void update(ICRenderNode renderNode) {
        if (this.upPressed || this.downPressed || this.leftPressed || this.rightPressed) {
            Vector3 panDelta = new Vector3();
            double deltaPerTick = 0.05;
            panDelta.z = (this.upPressed ? -deltaPerTick : 0.0) + (this.downPressed ? deltaPerTick : 0.0);
            panDelta.x = (this.leftPressed ? -deltaPerTick : 0.0) + (this.rightPressed ? deltaPerTick : 0.0);
            renderNode.applyPanningDelta(panDelta);
        }
        if (this.layerUpPressed) {
            renderNode.setLayer(renderNode.getLayer() + 1);
        } else if (this.layerDownPressed) {
            renderNode.setLayer(renderNode.getLayer() - 1);
        }
        this.layerUpPressed = false;
        this.layerDownPressed = false;
    }

    @Override
    public void mouseButtonPressed(ICRenderNode renderNode, Vector3 mousePosition, int glfwMouseButton) {
        switch (glfwMouseButton) {
            case 0: {
                this.leftMouseDown = true;
                this.initialLeftMousePosition.set(mousePosition);
                break;
            }
            case 1: {
                this.rightMouseDown = true;
                this.initialRightMousePosition.set(mousePosition);
                break;
            }
        }
        this.selectedTool.toolStart(mousePosition, glfwMouseButton);
    }

    @Override
    public void mouseButtonReleased(ICRenderNode renderNode, Vector3 mousePosition, int glfwMouseButton) {
        switch (glfwMouseButton) {
            case 0: {
                this.leftMouseDown = false;
                break;
            }
            case 1: {
                this.rightMouseDown = false;
                break;
            }
        }
        this.selectedTool.toolReleased(mousePosition, glfwMouseButton);
    }

    @Override
    public void mouseButtonDragged(ICRenderNode renderNode, Vector3 mousePosition, Vector3 delta, int glfwMouseButton) {
        if (!this.selectedTool.toolDragged(mousePosition, delta, glfwMouseButton)) {
            // empty if block
        }
    }

    @Override
    public void mouseScrolled(ICRenderNode renderNode, Vector3 mousePosition, double scroll) {
        if (!this.selectedTool.toolScrolled(mousePosition, scroll)) {
            renderNode.moveZoomAt(mousePosition, scroll * 0.3);
        }
    }

    @Override
    public void layerChanged(ICRenderNode renderNode, int previousLayer, int newLayer) {
        if (this.leftMouseDown) {
            this.initialLeftMousePosition.y = newLayer;
        }
        if (this.rightMouseDown) {
            this.initialRightMousePosition.y = newLayer;
        }
        this.selectedTool.toolLayerChanged(previousLayer, newLayer);
    }

    @Override
    public void onRenderOverlay(ICRenderNode renderNode, Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        this.lastMousePosition.set(mousePosition);
        this.selectedTool.renderOverlay(mousePosition, isFirstHit, ccrs, getter, matrixStack);
    }

    @Override
    public void buildTooltip(ICRenderNode renderNode, Vector3 mousePosition, boolean isFirstHit, List<Component> tooltip) {
        this.selectedTool.buildTooltip(mousePosition, isFirstHit, tooltip);
    }
}

