/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import java.util.ArrayList;
import mrtjp.projectred.redui.AbstractButtonNode;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.ButtonNode;
import mrtjp.projectred.redui.RedUINode;

public class ButtonArrayNode
extends AbstractGuiNode {
    private final Listener listener;
    private final int rows;
    private final int columns;
    private final int spacing;
    private final ArrayList<AbstractButtonNode> buttons = new ArrayList();

    public ButtonArrayNode(Listener listener, int rows, int columns, int spacing) {
        this.listener = listener;
        this.rows = rows;
        this.columns = columns;
        this.spacing = spacing;
        this.initButtons();
    }

    private void initButtons() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                AbstractButtonNode button = this.createButton(i * this.columns + j);
                this.addChild((RedUINode)button);
                this.buttons.add(button);
            }
        }
    }

    private void resizeButtons(int bw, int bh, int spacing) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                AbstractButtonNode button = this.buttons.get(i * this.columns + j);
                button.setSize(bw, bh);
                button.setPosition(j * (bw + spacing), i * (bh + spacing));
            }
        }
        this.setSize(this.columns * (bw + spacing) - spacing, this.rows * (bh + spacing) - spacing);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    public void setGridSize(int width, int height) {
        int bw = (width + this.spacing) / this.columns - this.spacing;
        int bh = (height + this.spacing) / this.rows - this.spacing;
        this.resizeButtons(bw, bh, this.spacing);
    }

    public void setButtonSize(int buttonWidth, int buttonHeight) {
        this.resizeButtons(buttonWidth, buttonHeight, this.spacing);
    }

    protected AbstractButtonNode createButton(int index) {
        ButtonNode button = new ButtonNode();
        button.setButtonText(this.listener.getButtonText(index));
        button.setClickFunction(() -> this.listener.onButtonClicked(index));
        button.setIsSelectedFunction(() -> this.listener.isButtonSelected(index));
        button.setIsEnabledFunction(() -> this.listener.isButtonEnabled(index));
        return button;
    }

    public static interface Listener {
        public String getButtonText(int var1);

        public void onButtonClicked(int var1);

        public boolean isButtonEnabled(int var1);

        public boolean isButtonSelected(int var1);
    }
}

