/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Optional;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.IPathFinder;
import mrtjp.fengine.assemble.PathFinderResult;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.IIOConnectionTile;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.RedstoneGateTile;
import mrtjp.projectred.fabrication.engine.log.MultipleDriversError;
import net.minecraft.nbt.CompoundTag;

public abstract class SingleBitIOGateTile
extends RedstoneGateTile
implements IIOConnectionTile {
    public static final int IO_BIT_PACKET = 7;
    protected byte ioBit = 0;
    private int regId = 136;

    public SingleBitIOGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128405_("reg", this.regId);
        tag.m_128344_("io_bit", this.ioBit);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.regId = tag.m_128451_("reg");
        this.ioBit = tag.m_128441_("colour") ? tag.m_128445_("colour") : tag.m_128445_("io_bit");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeByte((int)this.ioBit);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.ioBit = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 7: {
                this.ioBit = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendIOBitUpdate() {
        this.getWriteStream(7).writeByte((int)this.ioBit);
    }

    protected void toggleWorldInput() {
        this.getEditor().getStateMachine().onInputRegistersChanged(this.getIOSide(), this::toggleWorldInputMask);
    }

    protected short toggleWorldInputMask(short currentMask) {
        return (short)(currentMask ^ 1 << this.ioBit);
    }

    protected void shiftIOBit(boolean up) {
        this.ioBit = (byte)((this.ioBit + (up ? 1 : 15)) % 16);
        this.sendIOBitUpdate();
        this.getEditor().markTileChange();
    }

    protected void toggleDirection() {
        this.configureShapeAndSend((this.getShape() + 1) % 2);
    }

    protected int getStaticOutputRegister(int ioBit) {
        return PRFabricationEngine.outputRegisterId(this.getIOSide(), ioBit);
    }

    protected int getStaticInputRegister(int ioBit) {
        return PRFabricationEngine.inputRegisterId(this.getIOSide(), ioBit);
    }

    @Override
    protected boolean canRotate() {
        return false;
    }

    @Override
    public boolean isInputIOMode() {
        return this.getShape() == 0;
    }

    @Override
    public int getIOSide() {
        return this.getRotation();
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        int newState;
        int oldState = this.getState();
        if (oldState != (newState = this.pullInputMask(container) & 0xF | this.pullOutputMask(container) << 4)) {
            this.setState(newState);
            this.sendStateUpdate();
        }
    }

    protected int pullInputMask(ICSimulationContainer container) {
        return !this.isInputIOMode() && container.pullRegisterValue(this.regId) != 0 ? 4 : 0;
    }

    protected int pullOutputMask(ICSimulationContainer container) {
        return this.isInputIOMode() && container.pullRegisterValue(this.regId) != 0 ? 4 : 0;
    }

    public int state2() {
        return this.ioBit & 0xFF;
    }

    @Override
    protected int redstoneOutputMask() {
        return this.isInputIOMode() ? 0 : 4;
    }

    @Override
    protected int redstoneInputMask() {
        return this.isInputIOMode() ? 4 : 0;
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        this.regId = this.isInputIOMode() ? allocator.allocRegisterID(this.getStaticInputRegister(this.ioBit)) : 136;
    }

    @Override
    public void locate(IPathFinder pathFinder) {
        if (!this.isInputIOMode()) {
            int absR = this.toAbsoluteRotation(2);
            int absDir = IRotatableICTile.rotationToDir(absR);
            PathFinderResult pfr = pathFinder.doPathFinding((d, p) -> d == absDir);
            if (pfr.outputRegisters.size() > 1) {
                this.getEditor().getStateMachine().getCompilerLog().addProblem(new MultipleDriversError(this.getPos(), pfr.outputRegisters));
            }
            if (!pfr.outputRegisters.isEmpty()) {
                this.regId = pfr.outputRegisters.get(0);
            }
        }
    }

    @Override
    public void registerRemaps(ICAssemblyTile.RemapRegistry remapRegistry) {
        if (!this.isInputIOMode() && this.regId != 136) {
            remapRegistry.addRemap(this.regId, this.getStaticOutputRegister(this.ioBit));
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        this.regId = remapProvider.getRemappedRegisterID(this.regId);
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
    }

    @Override
    public Optional<Integer> getOutputRegister(int outDir, int outPort) {
        int gateOutputDir = IRotatableICTile.rotationToDir(this.toAbsoluteRotation(2));
        return this.isInputIOMode() && outDir == gateOutputDir ? Optional.of(this.regId) : Optional.empty();
    }

    @Override
    public Optional<Integer> getInputRegister(int inDir, int inPort) {
        int gateInputDir = IRotatableICTile.rotationToDir(this.toAbsoluteRotation(2));
        return !this.isInputIOMode() && inDir == gateInputDir ? Optional.of(this.regId) : Optional.empty();
    }
}

