/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SidedRedstoneGateTile;
import net.minecraft.network.chat.Component;

public abstract class SimpleGateTile
extends SidedRedstoneGateTile {
    public static final Cuboid6[] ZONE_BOUNDS = new Cuboid6[16];

    public SimpleGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        SimpleGateTile.addDeadSidesInteractions(zones, this.interactMask(), this::getBoundsForIOToggleZone, this::toggleDeadSide, this::getDeadSideToolTip);
    }

    protected Component getDeadSideToolTip(int r) {
        boolean isEnabled = (this.getShape() & this.rotationToDeadSideBit(r)) == 0;
        return Component.m_237115_((String)(isEnabled ? "projectred_fabrication.interact.side_enabled" : "projectred_fabrication.interact.side_disabled")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY);
    }

    protected Cuboid6 getBoundsForIOToggleZone(int r) {
        return ZONE_BOUNDS[this.getRotation() << 2 | r];
    }

    protected void toggleDeadSide(int r) {
        if (this.getDeadSides() == 0) {
            return;
        }
        int oldShape = this.getShape();
        int shape = oldShape ^ this.rotationToDeadSideBit(r);
        if (Integer.bitCount(shape) > this.getMaxDeadSides()) {
            return;
        }
        this.configureShapeAndSend(shape);
    }

    public static void addDeadSidesInteractions(List<InteractionZone> zones, int mask, Function<Integer, Cuboid6> boundsForR, Consumer<Integer> toggleForR, Function<Integer, Component> tooltipForR) {
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) == 0) continue;
            int fr = r;
            zones.add(new SimpleInteractionZone.Builder().bounds(() -> (Cuboid6)boundsForR.apply(fr)).leftClickAction(() -> toggleForR.accept(fr)).tooltip(() -> (Component)tooltipForR.apply(fr)).build());
        }
    }

    protected int interactMask() {
        return 0;
    }

    protected int getDeadSides() {
        return 0;
    }

    protected int getMaxDeadSides() {
        return this.getDeadSides() - 1;
    }

    protected int rotationToDeadSideBit(int r) {
        return 1 << r - 1;
    }

    protected abstract ICGate createGate();

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        ArrayList<Integer> inputRegistersList = new ArrayList<Integer>();
        ArrayList<Integer> outputRegistersList = new ArrayList<Integer>();
        for (int r = 0; r < 4; ++r) {
            if (inputRegisters[r] != -1) {
                inputRegistersList.add(inputRegisters[r]);
            }
            if (outputRegisters[r] == -1) continue;
            outputRegistersList.add(outputRegisters[r]);
        }
        collector.addGate(gateId, this.createGate(), inputRegistersList, outputRegistersList);
    }

    static {
        Cuboid6[] sideBoxes = new Cuboid6[]{new Cuboid6(6.0, 2.0, 0.0, 10.0, 2.5, 6.0), new Cuboid6(10.0, 2.0, 6.0, 16.0, 2.5, 10.0), new Cuboid6(6.0, 2.0, 10.0, 10.0, 2.5, 16.0), new Cuboid6(0.0, 2.0, 6.0, 6.0, 2.5, 10.0)};
        for (int sr = 0; sr < 4; ++sr) {
            for (int tr = 0; tr < 4; ++tr) {
                int i = sr << 2 | tr;
                SimpleGateTile.ZONE_BOUNDS[i] = sideBoxes[sr].copy().apply((Transformation)new Scale(0.0625)).apply(Rotation.quarterRotations[tr].at(Vector3.CENTER));
            }
        }
    }
}

