/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import java.util.List;
import java.util.function.Consumer;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.TimedStateGateTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class RedstoneTimerGateTile
extends TimedStateGateTile {
    public static final int START_TIME_PACKET = 15;
    public static final int MAX_TIME_PACKET = 16;
    protected int pointerMax = 38;
    protected long pointerStartTime = -1L;

    public RedstoneTimerGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128356_("tstart", this.pointerStartTime);
        tag.m_128405_("tmax", this.pointerMax);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.pointerStartTime = tag.m_128454_("tstart");
        this.pointerMax = tag.m_128451_("tmax");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeLong(this.pointerStartTime);
        out.writeInt(this.pointerMax);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.pointerStartTime = in.readLong();
        this.pointerMax = in.readInt();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 15: {
                this.pointerStartTime = in.readLong();
                break;
            }
            case 16: {
                this.pointerMax = in.readInt();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendTimeStateUpdate() {
        this.getWriteStream(15).writeLong(this.pointerStartTime);
    }

    protected void sendMaxTimeUpdate() {
        this.getWriteStream(16).writeInt(this.pointerMax);
    }

    @Override
    public void buildToolTip(List<Component> toolTip) {
        super.buildToolTip(toolTip);
        int tmax = this.pointerMax + 2;
        double smax = (double)tmax * 0.05;
        toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.tiles.timer.interval").m_7220_((Component)Component.m_237113_((String)": %.2fs (%d ".formatted(smax, tmax))).m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.unit.ticks")).m_7220_((Component)Component.m_237113_((String)")")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        RedstoneTimerGateTile.addTimerAdjustmentInteractionZones(zones, this::addTimerMax);
    }

    private void addTimerMax(int delta) {
        int newMax = this.pointerMax + delta;
        int min = Math.max(4, Configurator.minTimerTicks) - 2;
        if (newMax < min) {
            newMax = min;
        }
        if (newMax != this.pointerMax) {
            this.pointerMax = newMax;
            this.sendMaxTimeUpdate();
            this.getEditor().markTileChange();
        }
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        super.onSimRegistersChanged(rMask, container);
        long startTime = container.pullLongValue(this.timeRegs, 0);
        if (startTime != this.pointerStartTime) {
            this.pointerStartTime = startTime;
            this.sendTimeStateUpdate();
        }
    }

    public abstract boolean isPointerStarted();

    public int pointerMax() {
        return this.pointerMax;
    }

    public int pointerValue() {
        long simTime = this.getEditor().getStateMachine().getSimSystemTime();
        return (int)(simTime - this.pointerStartTime);
    }

    public static void addTimerAdjustmentInteractionZones(List<InteractionZone> zones, Consumer<Integer> adjustFunc) {
        double w = 0.1875;
        double h = 0.03125;
        double l = 0.09375;
        double x = 0.0;
        double y = 0.125;
        double z = 0.0;
        int[] deltas = new int[]{200, 20, 1, -1, -20, -200};
        int split = deltas.length / 2;
        for (int i = 0; i < deltas.length; ++i) {
            Cuboid6 box = new Cuboid6(0.0, 0.0, 0.0, w, h, l);
            if (i < split) {
                box.add(x, y, z + l * (double)i);
            } else {
                box.add(x, y, 1.0 - l * (double)split + l * (double)(i - split));
            }
            int tDelta = deltas[i];
            double sDelta = (double)tDelta * 0.05;
            MutableComponent text = Component.m_237113_((String)"%+.2fs".formatted(sDelta));
            MutableComponent toolTip = Component.m_237113_((String)"%+.2fs (%+d ".formatted(sDelta, tDelta)).m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.unit.ticks")).m_7220_((Component)Component.m_237113_((String)")")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY);
            zones.add(new SimpleInteractionZone.Builder().bounds(() -> box).boundingBoxLineWidth(2.0).leftClickAction(() -> adjustFunc.accept(tDelta)).text((Component)text).tooltip((Component)toolTip).build());
        }
    }
}

