/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor.tools;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.uv.IconTransformation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

public class HotKeyInteractionZone
implements InteractionZone {
    private final Cuboid6 bounds;
    private final int keyCode;
    private final Runnable keyAction;
    private final int backgroundColor;
    private final Component text;
    private final Supplier<Object> icon;
    private final Transformation blockTransform;

    private HotKeyInteractionZone(Builder builder) {
        this.bounds = builder.bounds;
        this.keyCode = builder.keyCode;
        this.keyAction = builder.keyAction;
        this.backgroundColor = builder.backgroundColor;
        this.text = builder.text;
        this.icon = builder.icon;
        this.blockTransform = new Scale(this.bounds.max.copy().subtract(this.bounds.min)).with((Transformation)new Translation(this.bounds.min));
    }

    @Override
    public Cuboid6 getBounds() {
        return this.bounds;
    }

    @Override
    public void onLeftClick() {
        this.keyAction.run();
    }

    @Override
    public void onRightClick() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderZone(CCRenderState ccrs, MultiBufferSource getter, PoseStack poseStack, boolean isSelected, boolean isMouseOver) {
        ccrs.reset();
        ccrs.bind(ICRenderTypes.selectionRenderType, getter, poseStack);
        ccrs.baseColour = this.backgroundColor;
        ccrs.alphaOverride = isSelected && isMouseOver ? 255 : (isSelected ? 128 : (isMouseOver ? 64 : 32));
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)this.getBounds(), (int)1);
        ccrs.reset();
        ccrs.bind(ICRenderTypes.interactionZoneLinesRenderType.apply(2.0), getter, poseStack);
        ccrs.baseColour = EnumColour.WHITE.rgba();
        RenderUtils.bufferCuboidOutline((VertexConsumer)ccrs.getConsumer(), (Cuboid6)this.getBounds(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ccrs.reset();
        ccrs.bind(ICRenderTypes.layersRenderType, getter, poseStack);
        ccrs.setPipeline(new IVertexOperation[]{new IconTransformation((TextureAtlasSprite)this.icon.get()), this.blockTransform});
        BlockRenderer.renderFullBlock((CCRenderState)ccrs, (int)-3);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void buildToolTip(List<Component> tooltip) {
        String keyName = Objects.requireNonNullElse(GLFW.glfwGetKeyName((int)this.keyCode, (int)0), "???");
        tooltip.add((Component)Component.m_237113_((String)("[" + keyName + "] ")).m_7220_(this.text).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
    }

    @Override
    public boolean canRespondToKey(int glfwKeyCode, int glfwFlags) {
        return glfwKeyCode == this.keyCode;
    }

    @Override
    public boolean onKeyPressed(int glfwKeyCode, int glfwFlags) {
        if (glfwKeyCode == this.keyCode) {
            this.keyAction.run();
            return true;
        }
        return false;
    }

    public static class Builder {
        private Cuboid6 bounds = Cuboid6.full;
        private int keyCode = -1;
        private Runnable keyAction = () -> {};
        private int backgroundColor = EnumColour.GRAY.rgba(64);
        private Component text = Component.m_130674_((String)"//TODO label");
        private Supplier<Object> icon = () -> null;

        public Builder bounds(Cuboid6 bounds) {
            this.bounds = bounds;
            return this;
        }

        public Builder keyCode(int keyCode) {
            this.keyCode = keyCode;
            return this;
        }

        public Builder keyAction(Runnable keyAction) {
            this.keyAction = keyAction;
            return this;
        }

        public Builder backgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder text(Component text) {
            this.text = text;
            return this;
        }

        public Builder icon(Supplier<Object> icon) {
            this.icon = icon;
            return this;
        }

        public InteractionZone build() {
            return new HotKeyInteractionZone(this);
        }
    }
}

