/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.assemble;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mrtjp.fengine.TileCoord;

public class PathFinderNode {
    public final TileCoord pos;
    public final int inputDir;
    public final int inputPort;
    private final List<PathFinderNode> trail = new LinkedList<PathFinderNode>();

    public PathFinderNode(TileCoord pos, int inputDir, int inputPort) {
        this(pos, inputDir, inputPort, Collections.emptyList());
    }

    private PathFinderNode(TileCoord pos, int inputDir, int inputPort, List<PathFinderNode> trail) {
        this.pos = pos;
        this.inputDir = inputDir;
        this.inputPort = inputPort;
        this.trail.addAll(trail);
        this.trail.add(this);
    }

    public PathFinderNode getRootNode() {
        return this.trail.get(0);
    }

    public PathFinderNode moveTo(TileCoord pos, int inputDir, int inputPort) {
        return new PathFinderNode(pos, inputDir, inputPort, this.trail);
    }

    public void forEachPropagation(PropagationConsumer propConsumer) {
        for (int i = 0; i < this.trail.size() - 1; ++i) {
            PathFinderNode node = this.trail.get(i);
            PathFinderNode nextNode = this.trail.get(i + 1);
            int inDir = node.inputDir;
            int outDir = TileCoord.oppositeDir(nextNode.inputDir);
            int inPort = node.inputPort;
            int outPort = nextNode.inputPort;
            propConsumer.accept(node.pos, inDir, inPort, outDir, outPort);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathFinderNode) {
            PathFinderNode that = (PathFinderNode)obj;
            return that.pos.equals(this.pos) && that.inputDir == this.inputDir && that.inputPort == this.inputPort;
        }
        return false;
    }

    public int hashCode() {
        int result = this.pos.hashCode();
        result = (result << 3) + this.inputDir;
        result = (result << 4) + this.inputPort;
        return result;
    }

    public String toString() {
        return String.format("PathFinderNode(pos:%s, inDir:%d, inPort:%d", this.pos.toString(), this.inputDir, this.inputPort);
    }

    public static interface PropagationConsumer {
        public void accept(TileCoord var1, int var2, int var3, int var4, int var5);
    }
}

