/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import mrtjp.fengine.TileCoord;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.fengine.api.ICStepThroughAssembler;
import mrtjp.fengine.assemble.PathFinder;
import mrtjp.fengine.assemble.PathFinderManifest;
import mrtjp.fengine.assemble.StepTree;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICRegister;
import mrtjp.fengine.tiles.FETileMap;

public class ICStepThroughAssemblerImpl
implements ICStepThroughAssembler {
    private final StepTree<ICStepThroughAssembler.AssemblerStepType, AssemblerStepResult> tree = new StepTree<ICStepThroughAssembler.AssemblerStepType, AssemblerStepResult>(new StepTreeEventReceiver());
    private final Map<Integer, ICRegister> registers = new HashMap<Integer, ICRegister>();
    private final Map<Integer, ICGate> gates = new HashMap<Integer, ICGate>();
    private final Map<Integer, ArrayList<Integer>> regDependents = new HashMap<Integer, ArrayList<Integer>>();
    private final Map<Integer, ArrayList<Integer>> regDependencies = new HashMap<Integer, ArrayList<Integer>>();
    private final Map<Integer, ArrayList<Integer>> gateDependents = new HashMap<Integer, ArrayList<Integer>>();
    private final Map<Integer, ArrayList<Integer>> gateDependencies = new HashMap<Integer, ArrayList<Integer>>();
    private final List<FETileMap> exploredTileMaps = new ArrayList<FETileMap>();
    private final List<ICFlatMap> exploredFlatMaps = new ArrayList<ICFlatMap>();
    private final Queue<TileMapRemapPair> openTileMaps = new LinkedList<TileMapRemapPair>();
    private final Queue<FlatMapRemapPair> openFlatMaps = new LinkedList<FlatMapRemapPair>();
    private final PathFinderManifest pathFinderManifest = new PathFinderManifest();
    private final Map<Integer, Integer> registerIDRemaps = new HashMap<Integer, Integer>();
    private int nextRegID = 0;
    private int nextGateID = 0;
    private ICStepThroughAssembler.EventReceiver eventReceiver = null;
    private boolean assemblyStarted = false;

    @Override
    public int allocRegisterID() {
        return this.nextRegID++;
    }

    @Override
    public int allocGateID() {
        return this.nextGateID++;
    }

    @Override
    public int allocRegisterID(int id) {
        if (id >= this.nextRegID) {
            this.nextRegID = id + 1;
        }
        return id;
    }

    @Override
    public int allocGateID(int id) {
        if (id >= this.nextGateID) {
            this.nextGateID = id + 1;
        }
        return id;
    }

    @Override
    public int getRemappedRegisterID(int id) {
        return this.registerIDRemaps.getOrDefault(id, id);
    }

    @Override
    public void addRemap(int oldID, int newID) {
        this.registerIDRemaps.put(oldID, this.getRemappedRegisterID(newID));
    }

    @Override
    public void addRegister(int id, ICRegister r) {
        if (this.registers.containsKey(id)) {
            System.out.println("Warning: Dropping register " + id + " due to duplicate ID");
            return;
        }
        this.allocRegisterID(id);
        this.registers.put(id, r);
    }

    @Override
    public void addGate(int id, ICGate gate, List<Integer> drivingRegs, List<Integer> drivenRegs) {
        if (this.gates.containsKey(id)) {
            throw new IllegalArgumentException("Gate ID " + id + " already exists");
        }
        this.allocGateID(id);
        this.gates.put(id, gate);
        for (int regID : drivingRegs) {
            this.regDependents.putIfAbsent(regID, new ArrayList());
            this.regDependents.get(regID).add(id);
        }
        for (int regID : drivenRegs) {
            this.regDependencies.putIfAbsent(regID, new ArrayList());
            this.regDependencies.get(regID).add(id);
        }
        this.gateDependents.putIfAbsent(id, new ArrayList());
        this.gateDependents.get(id).addAll(drivenRegs);
        this.gateDependencies.putIfAbsent(id, new ArrayList());
        this.gateDependencies.get(id).addAll(drivingRegs);
    }

    @Override
    public void addTileMap(FETileMap map, Map<Integer, Integer> remaps) {
        this.openTileMaps.add(new TileMapRemapPair(map, remaps));
    }

    @Override
    public void addFlatMap(ICFlatMap flatMap, Map<Integer, Integer> remaps) {
        this.openFlatMaps.add(new FlatMapRemapPair(flatMap, remaps));
    }

    private void mergeTileMap(FETileMap map, Map<Integer, Integer> remaps) {
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PRE, () -> {
            System.out.println("Assembly merge tile map setup");
            this.pathFinderManifest.clear();
            this.registerIDRemaps.clear();
            this.registerIDRemaps.putAll(remaps);
            return new AssemblerStepResult();
        });
        Collection<FETileMap.TileMapEntry> entries = map.getEntries();
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE1, () -> {
            System.out.println("Assembly Phase 1: Allocations");
            for (FETileMap.TileMapEntry entry : entries) {
                this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.PHASE1_ALLOC, () -> {
                    CachedAllocator allocator = new CachedAllocator();
                    entry.getTile().allocate(allocator);
                    return new AssemblerStepResult(entry.getCoord(), allocator.registerIds, allocator.gateIds);
                });
            }
            return new AssemblerStepResult();
        });
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE2, () -> {
            System.out.println("Assembly Phase 2: Pathfinding");
            for (FETileMap.TileMapEntry entry : entries) {
                this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.PHASE2_PATHFIND, () -> {
                    System.out.println("Pathfinding at " + entry.getCoord());
                    PathFinder pathFinder = new PathFinder(map, entry.getCoord(), this.pathFinderManifest);
                    entry.getTile().locate(pathFinder);
                    return new AssemblerStepResult(entry.getCoord());
                });
            }
            return new AssemblerStepResult();
        });
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE3, () -> {
            System.out.println("Assembly Phase 2: Pathfinding lookup");
            for (FETileMap.TileMapEntry entry : entries) {
                this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.PHASE3_PF_MANIFEST_SEARCH, () -> {
                    System.out.println("Searching manifest at " + entry.getCoord());
                    entry.getTile().searchManifest(this.pathFinderManifest.getManifest(entry.getCoord()));
                    return new AssemblerStepResult(entry.getCoord());
                });
            }
            return new AssemblerStepResult();
        });
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE4, () -> {
            System.out.println("Assembly Phase 4: Declare remaps");
            for (FETileMap.TileMapEntry entry : entries) {
                this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.PHASE4_REGISTER_REMAPS, () -> {
                    HashMap<Integer, Integer> registeredRemaps = new HashMap<Integer, Integer>();
                    entry.getTile().registerRemaps((a, b) -> {
                        registeredRemaps.put(a, b);
                        this.addRemap(a, b);
                    });
                    return new AssemblerStepResult(entry.getCoord(), registeredRemaps);
                });
            }
            return new AssemblerStepResult();
        });
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE5, () -> {
            System.out.println("Assembly Phase 5: Consume remaps");
            for (FETileMap.TileMapEntry entry : entries) {
                this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.PHASE5_CONSUME_REMAPS, () -> {
                    HashMap<Integer, Integer> consumedRemaps = new HashMap<Integer, Integer>();
                    entry.getTile().consumeRemaps(a -> {
                        int b = this.getRemappedRegisterID(a);
                        if (a != b) {
                            consumedRemaps.put(a, b);
                        }
                        return b;
                    });
                    return new AssemblerStepResult(entry.getCoord(), consumedRemaps);
                });
            }
            return new AssemblerStepResult();
        });
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE6, () -> {
            System.out.println("Assembly Phase 6: Register and Gate collection");
            for (FETileMap.TileMapEntry entry : entries) {
                this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.PHASE6_COLLECT, () -> {
                    CachedCollector collector = new CachedCollector();
                    entry.getTile().collect(collector);
                    return new AssemblerStepResult(entry.getCoord(), collector.registerIds, collector.gateIds);
                });
            }
            return new AssemblerStepResult();
        });
        this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_POST, () -> {
            System.out.println("Assembly merge tile map cleanup");
            this.pathFinderManifest.clear();
            this.registerIDRemaps.clear();
            this.exploredTileMaps.add(map);
            return new AssemblerStepResult();
        });
    }

    private void mergeFlatMap(ICFlatMap map, Map<Integer, Integer> remaps) {
        int newId;
        int oldId;
        HashMap<Integer, Integer> gateTransforms = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> regTransforms = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, ICRegister> entry : map.getRegisters().entrySet()) {
            oldId = entry.getKey();
            newId = remaps.getOrDefault(oldId, this.allocRegisterID());
            regTransforms.put(oldId, newId);
        }
        for (Map.Entry<Integer, Object> entry : map.getGates().entrySet()) {
            oldId = entry.getKey();
            newId = this.allocGateID();
            gateTransforms.put(oldId, newId);
        }
        for (Map.Entry<Integer, Object> entry : map.getRegisters().entrySet()) {
            oldId = entry.getKey();
            newId = (Integer)regTransforms.get(oldId);
            if (this.registers.containsKey(newId)) continue;
            this.addRegister(newId, (ICRegister)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : map.getGates().entrySet()) {
            oldId = entry.getKey();
            newId = (Integer)gateTransforms.get(oldId);
            List<Integer> newDriving = map.getGateDependencies().get(oldId).stream().map(regTransforms::get).collect(Collectors.toList());
            List<Integer> newDriven = map.getGateDependents().get(oldId).stream().map(regTransforms::get).collect(Collectors.toList());
            this.addGate(newId, (ICGate)entry.getValue(), newDriving, newDriven);
        }
        this.exploredFlatMaps.add(map);
    }

    private AssemblerStepResult checkOpenTileMapTask() {
        if (!this.openTileMaps.isEmpty()) {
            TileMapRemapPair pair = this.openTileMaps.poll();
            this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP, () -> {
                this.mergeTileMap(pair.map, pair.remaps);
                return new AssemblerStepResult();
            });
            this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_TILE_MAPS, this::checkOpenTileMapTask);
        } else {
            this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_FLAT_MAPS, this::checkOpenFlatMapTask);
        }
        return new AssemblerStepResult();
    }

    private AssemblerStepResult checkOpenFlatMapTask() {
        if (!this.openFlatMaps.isEmpty()) {
            FlatMapRemapPair pair = this.openFlatMaps.poll();
            this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.MERGE_FLAT_MAP, () -> {
                this.mergeFlatMap(pair.map, pair.remaps);
                return new AssemblerStepResult();
            });
            this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_FLAT_MAPS, this::checkOpenFlatMapTask);
        }
        return new AssemblerStepResult();
    }

    private void checkStarted() {
        if (!this.assemblyStarted) {
            this.tree.addStep(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_TILE_MAPS, this::checkOpenTileMapTask);
            this.assemblyStarted = true;
        }
    }

    @Override
    public ICFlatMap result() {
        this.checkStarted();
        while (this.tree.stepsRemaining() > 0) {
            this.tree.stepOver();
        }
        return new ICFlatMap(this.registers, this.gates, this.regDependents, this.regDependencies, this.gateDependents, this.gateDependencies);
    }

    private int getMapIndex() {
        return this.exploredFlatMaps.size() + this.exploredTileMaps.size();
    }

    @Override
    public void setEventReceiver(ICStepThroughAssembler.EventReceiver receiver) {
        this.eventReceiver = receiver;
    }

    @Override
    public void stepOver() {
        this.checkStarted();
        this.tree.stepOver();
    }

    @Override
    public void stepIn() {
        this.checkStarted();
        this.tree.stepIn();
    }

    @Override
    public void stepOut() {
        this.checkStarted();
        this.tree.stepOut();
    }

    @Override
    public int stepsRemaining() {
        return this.tree.stepsRemaining();
    }

    @Override
    public boolean isDone() {
        return this.assemblyStarted && this.tree.isDone();
    }

    private static class AssemblerStepResult
    implements ICStepThroughAssembler.AssemblerStepResult {
        private ICStepThroughAssembler.AssemblerStepType step;
        private List<Integer> treePath;
        private final List<TileCoord> tileCoords;
        private final List<Integer> registerIds;
        private final List<Integer> gateIds;
        private final Map<Integer, Integer> registerRemaps;

        public AssemblerStepResult(List<TileCoord> tileCoords, List<Integer> registerIds, List<Integer> gateIds, Map<Integer, Integer> registerRemaps) {
            this.tileCoords = tileCoords;
            this.registerIds = registerIds;
            this.gateIds = gateIds;
            this.registerRemaps = registerRemaps;
        }

        public AssemblerStepResult() {
            this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
        }

        public AssemblerStepResult(TileCoord tileCoord) {
            this(Collections.singletonList(tileCoord), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
        }

        public AssemblerStepResult(TileCoord tileCoord, List<Integer> registerIds, List<Integer> gateIds) {
            this(Collections.singletonList(tileCoord), registerIds, gateIds, Collections.emptyMap());
        }

        public AssemblerStepResult(TileCoord tileCoord, Map<Integer, Integer> registerRemaps) {
            this(Collections.singletonList(tileCoord), Collections.emptyList(), Collections.emptyList(), registerRemaps);
        }

        public void setStepType(ICStepThroughAssembler.AssemblerStepType step) {
            this.step = step;
        }

        public void setTreePath(List<Integer> treePath) {
            this.treePath = treePath;
        }

        @Override
        public ICStepThroughAssembler.AssemblerStepType getStepType() {
            return this.step;
        }

        @Override
        public List<Integer> getTreePath() {
            return this.treePath;
        }

        @Override
        public List<TileCoord> getTileCoords() {
            return this.tileCoords;
        }

        @Override
        public List<Integer> getRegisterIds() {
            return this.registerIds;
        }

        @Override
        public List<Integer> getGateIds() {
            return this.gateIds;
        }

        @Override
        public Map<Integer, Integer> getRemappedRegisterIds() {
            return this.registerRemaps;
        }
    }

    private static class AssemblerStepDescriptor
    implements ICStepThroughAssembler.AssemblerStepDescriptor {
        private final ICStepThroughAssembler.AssemblerStepType step;
        private final List<Integer> treePath;

        public AssemblerStepDescriptor(ICStepThroughAssembler.AssemblerStepType step, List<Integer> treePath) {
            this.step = step;
            this.treePath = treePath;
        }

        @Override
        public ICStepThroughAssembler.AssemblerStepType getStepType() {
            return this.step;
        }

        @Override
        public List<Integer> getTreePath() {
            return this.treePath;
        }
    }

    private class CachedCollector
    implements ICAssemblyTile.Collector {
        public final List<Integer> registerIds = new LinkedList<Integer>();
        public final List<Integer> gateIds = new LinkedList<Integer>();
        public int addedTileMapCount = 0;
        public int addedFlatMapCount = 0;

        private CachedCollector() {
        }

        @Override
        public void addRegister(int id, ICRegister r) {
            ICStepThroughAssemblerImpl.this.addRegister(id, r);
            this.registerIds.add(id);
        }

        @Override
        public void addGate(int id, ICGate gate, List<Integer> drivingRegs, List<Integer> drivenRegs) {
            ICStepThroughAssemblerImpl.this.addGate(id, gate, drivingRegs, drivenRegs);
            this.gateIds.add(id);
        }

        @Override
        public void addTileMap(FETileMap map, Map<Integer, Integer> remaps) {
            ICStepThroughAssemblerImpl.this.addTileMap(map, remaps);
            ++this.addedTileMapCount;
        }

        @Override
        public void addFlatMap(ICFlatMap flatMap, Map<Integer, Integer> remaps) {
            ICStepThroughAssemblerImpl.this.addFlatMap(flatMap, remaps);
            ++this.addedFlatMapCount;
        }
    }

    private class CachedAllocator
    implements ICAssemblyTile.Allocator {
        public final List<Integer> registerIds = new LinkedList<Integer>();
        public final List<Integer> gateIds = new LinkedList<Integer>();

        private CachedAllocator() {
        }

        @Override
        public int allocRegisterID() {
            int i = ICStepThroughAssemblerImpl.this.allocRegisterID();
            this.registerIds.add(i);
            return i;
        }

        @Override
        public int allocRegisterID(int id) {
            int i = ICStepThroughAssemblerImpl.this.allocRegisterID(id);
            this.registerIds.add(i);
            return i;
        }

        @Override
        public int allocGateID() {
            int i = ICStepThroughAssemblerImpl.this.allocGateID();
            this.gateIds.add(i);
            return i;
        }

        @Override
        public int allocGateID(int id) {
            int i = ICStepThroughAssemblerImpl.this.allocGateID(id);
            this.gateIds.add(i);
            return i;
        }
    }

    private class StepTreeEventReceiver
    implements StepTree.StepTreeEventReceiver<ICStepThroughAssembler.AssemblerStepType, AssemblerStepResult> {
        private StepTreeEventReceiver() {
        }

        @Override
        public void onStepExecuted(List<Integer> treePath, ICStepThroughAssembler.AssemblerStepType stepType, AssemblerStepResult stepResult) {
            stepResult.setStepType(stepType);
            stepResult.setTreePath(treePath);
            if (ICStepThroughAssemblerImpl.this.eventReceiver != null) {
                ICStepThroughAssemblerImpl.this.eventReceiver.onStepExecuted(stepResult);
            }
        }

        @Override
        public void onStepAdded(List<Integer> treePath, ICStepThroughAssembler.AssemblerStepType stepType) {
            if (ICStepThroughAssemblerImpl.this.eventReceiver != null) {
                ICStepThroughAssemblerImpl.this.eventReceiver.onStepAdded(new AssemblerStepDescriptor(stepType, treePath));
            }
        }
    }

    private static class FlatMapRemapPair {
        ICFlatMap map;
        Map<Integer, Integer> remaps;

        public FlatMapRemapPair(ICFlatMap map, Map<Integer, Integer> remaps) {
            this.map = map;
            this.remaps = remaps;
        }
    }

    private static class TileMapRemapPair {
        FETileMap map;
        Map<Integer, Integer> remaps;

        public TileMapRemapPair(FETileMap map, Map<Integer, Integer> remaps) {
            this.map = map;
            this.remaps = remaps;
        }
    }
}

