/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine;

import java.util.Arrays;
import java.util.stream.IntStream;

public class TileCoord {
    public final int x;
    public final int y;
    public final int z;
    public static final TileCoord infinite = new TileCoord(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final TileCoord origin = new TileCoord(0, 0, 0);
    public static final int dirDown = 0;
    public static final int dirUp = 1;
    public static final int dirNorth = 2;
    public static final int dirSouth = 3;
    public static final int dirWest = 4;
    public static final int dirEast = 5;
    public static final int bitDown = 1;
    public static final int bitUp = 2;
    public static final int bitNorth = 4;
    public static final int bitSouth = 8;
    public static final int bitWest = 16;
    public static final int bitEast = 32;
    public static final int[] allDirs = new int[]{0, 1, 2, 3, 4, 5};
    public static final int dirMaskAll = 63;
    public static final int[] allPorts = IntStream.range(0, 16).toArray();
    public static final int portMaskAll = 0;
    public static final TileCoord[] dirOffsets = new TileCoord[]{new TileCoord(0, -1, 0), new TileCoord(0, 1, 0), new TileCoord(0, 0, -1), new TileCoord(0, 0, 1), new TileCoord(-1, 0, 0), new TileCoord(1, 0, 0)};

    public TileCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TileCoord) {
            TileCoord that = (TileCoord)obj;
            return this.x == that.x && this.y == that.y && this.z == that.z;
        }
        return false;
    }

    public int hashCode() {
        int result = this.x;
        result = (result << 8) + this.y;
        result = (result << 5) + this.z;
        return result;
    }

    public TileCoord copy() {
        return new TileCoord(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("TileCoord(x:%d, y:%d, z:%d)", this.x, this.y, this.z);
    }

    public TileCoord add(int dx, int dy, int dz) {
        return new TileCoord(this.x + dx, this.y + dy, this.z + dz);
    }

    public TileCoord subtract(int dx, int dy, int dz) {
        return new TileCoord(this.x - dx, this.y - dy, this.z - dz);
    }

    public TileCoord multiply(int i, int j, int k) {
        return new TileCoord(this.x * i, this.y * j, this.z * k);
    }

    public TileCoord divide(int i, int j, int k) {
        return new TileCoord(this.x / i, this.y / j, this.z / k);
    }

    public TileCoord add(TileCoord that) {
        return new TileCoord(this.x + that.x, this.y + that.y, this.z + that.z);
    }

    public TileCoord subtract(TileCoord that) {
        return new TileCoord(this.x - that.x, this.y - that.y, this.z - that.z);
    }

    public TileCoord multiply(TileCoord that) {
        return new TileCoord(this.x * that.x, this.y * that.y, this.z * that.z);
    }

    public TileCoord divide(TileCoord that) {
        return new TileCoord(this.x / that.x, this.y / that.y, this.z / that.z);
    }

    public TileCoord add(int d) {
        return new TileCoord(this.x + d, this.y + d, this.z + d);
    }

    public TileCoord subtract(int d) {
        return new TileCoord(this.x - d, this.y - d, this.z - d);
    }

    public TileCoord multiply(int d) {
        return new TileCoord(this.x * d, this.y * d, this.z * d);
    }

    public TileCoord divide(int d) {
        return new TileCoord(this.x / d, this.y / d, this.z / d);
    }

    public TileCoord negate() {
        return new TileCoord(-this.x, -this.y, -this.z);
    }

    public TileCoord max(TileCoord that) {
        return new TileCoord(Math.max(this.x, that.x), Math.max(this.y, that.y), Math.max(this.z, that.z));
    }

    public TileCoord min(TileCoord that) {
        return new TileCoord(Math.min(this.x, that.x), Math.min(this.y, that.y), Math.min(this.z, that.z));
    }

    public TileCoord offset(int dir) {
        return this.add(dirOffsets[dir]);
    }

    public TileCoord offset(int dir, int amount) {
        return this.add(dirOffsets[dir].multiply(amount));
    }

    public static int oppositeDir(int dir) {
        return dir ^ 1;
    }

    public static int[] maskToDirs(int mask) {
        return Arrays.stream(allDirs).filter(d -> (mask & 1 << d) != 0).toArray();
    }

    public static int dirsToMask(int[] dirs) {
        return Arrays.stream(dirs).reduce(0, (mask, d) -> mask | 1 << d);
    }

    public static int[] maskToPorts(int mask) {
        return Arrays.stream(allPorts).filter(d -> (mask & 1 << d) != 0).toArray();
    }

    public static int portsToMask(int[] ports) {
        return Arrays.stream(ports).reduce(0, (mask, d) -> mask | 1 << d);
    }
}

