/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.multipart.api.tile.RedstoneConnector;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.tile.BasePneumaticDeviceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TransposerBlockEntity
extends BasePneumaticDeviceBlockEntity
implements RedstoneConnector {
    public TransposerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExpansionBlocks.TRANSPOSER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected void onActivated() {
        if (this.importFromInventory()) {
            return;
        }
        this.suckEntities();
    }

    @Override
    protected void onDeactivated() {
    }

    protected int containerImportStackSize() {
        return 1;
    }

    private boolean importFromInventory() {
        LazyOptional itemCapOpt;
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (int)(this.side ^ 1));
        if (lookup.tile == null) {
            return false;
        }
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof WorldlyContainer) {
            int[] slots;
            WorldlyContainer wc = (WorldlyContainer)blockEntity;
            Direction extractDir = Direction.values()[lookup.otherDirection];
            for (int s : slots = wc.m_7071_(extractDir)) {
                int toImport;
                ItemStack removed;
                ItemStack stack = wc.m_8020_(s);
                if (stack.m_41619_() || !wc.m_7157_(s, stack, extractDir) || (removed = wc.m_7407_(s, toImport = Math.max(stack.m_41741_(), this.containerImportStackSize()))).m_41619_()) continue;
                this.itemQueue.add(new PneumaticTubePayload(removed));
                return true;
            }
        }
        if ((itemCapOpt = lookup.tile.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.values()[lookup.otherDirection])).isPresent()) {
            IItemHandler itemCap = (IItemHandler)itemCapOpt.orElseThrow(NullPointerException::new);
            for (int s = 0; s < itemCap.getSlots(); ++s) {
                ItemStack extracted = itemCap.extractItem(s, this.containerImportStackSize(), false);
                if (extracted.m_41619_()) continue;
                this.itemQueue.add(new PneumaticTubePayload(extracted));
                return true;
            }
        }
        return false;
    }

    private boolean suckEntities() {
        return false;
    }

    @Override
    public int getConnectionMask(int side) {
        return (side ^ 1) == this.side ? 0 : 31;
    }

    @Override
    public int weakPowerLevel(int side, int mask) {
        return 0;
    }
}

