/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.MaskedRedstonePart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.LinkedList;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.PlacementLib;
import mrtjp.projectred.core.RedstoneCenterLookup;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.init.CoreTags;
import mrtjp.projectred.core.part.IPropagationCenterPart;
import mrtjp.projectred.core.part.IPropagationPart;
import mrtjp.projectred.core.part.IRedstonePropagationPart;
import mrtjp.projectred.core.part.IRedwirePart;
import mrtjp.projectred.expansion.TubeType;
import mrtjp.projectred.expansion.part.BaseTubePart;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;

public class RedstoneTubePart
extends BaseTubePart
implements IRedstonePropagationPart,
IPropagationCenterPart,
MaskedRedstonePart,
IRedwirePart {
    private static final int KEY_SIGNAL = 10;
    private boolean hasRedstone = false;
    private byte signal = 0;

    public RedstoneTubePart(TubeType pipeType) {
        super(pipeType);
    }

    public boolean hasRedstone() {
        return this.hasRedstone;
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128379_("has_redstone", this.hasRedstone);
        tag.m_128344_("signal", this.signal);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.hasRedstone = tag.m_128471_("has_redstone");
        this.signal = tag.m_128445_("signal");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeBoolean(this.hasRedstone);
        packet.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.hasRedstone = packet.readBoolean();
        this.signal = packet.readByte();
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 10: {
                this.hasRedstone = packet.readBoolean();
                this.signal = packet.readByte();
                if (!Configurator.staticWires) break;
                this.tile().markRender();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendSignalUpdate() {
        this.sendUpdate(10, p -> p.writeBoolean(this.hasRedstone).writeByte((int)this.signal));
    }

    @Override
    public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack held, InteractionHand hand) {
        if (super.activate(player, hit, held, hand).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (held.m_41619_() && player.m_6047_() && this.hasRedstone) {
            if (!this.level().f_46443_) {
                if (!player.m_7500_()) {
                    PlacementLib.dropTowardsPlayer((Level)this.level(), (BlockPos)this.pos(), (ItemStack)new ItemStack((ItemLike)CoreItems.RED_ALLOY_INGOT_ITEM.get()), (Player)player);
                }
                this.hasRedstone = false;
                this.tile().notifyPartChange(null);
                this.sendSignalUpdate();
            }
            return InteractionResult.SUCCESS;
        }
        if (!held.m_41619_() && held.m_204117_(CoreTags.RED_ALLOY_INGOT_TAG) && !this.hasRedstone) {
            MicroMaterial newMat = ItemMicroBlock.getMaterialFromStack((ItemStack)held);
            if (!this.level().f_46443_) {
                this.hasRedstone = true;
                this.tile().notifyPartChange(null);
                this.sendSignalUpdate();
                SoundType sound = SoundType.f_56744_;
                this.level().m_5594_(null, this.pos(), sound.m_56777_(), SoundSource.BLOCKS, sound.m_56773_() + 0.5f, sound.m_56774_() * 0.8f);
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        if (!this.hasRedstone) {
            return super.getDrops();
        }
        LinkedList<ItemStack> drops = new LinkedList<ItemStack>();
        for (ItemStack drop : super.getDrops()) {
            drops.add(drop);
        }
        drops.add(new ItemStack((ItemLike)CoreItems.RED_ALLOY_INGOT_ITEM.get()));
        return drops;
    }

    protected int redstoneSignalLevel() {
        return RedstonePropagator.canRedwiresProvidePower() ? ((this.signal & 0xFF) + 16) / 17 : 0;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        if (!this.hasRedstone || !this.maskConnects(side)) {
            return 0;
        }
        return this.redstoneSignalLevel();
    }

    public boolean canConnectRedstone(int side) {
        return this.hasRedstone;
    }

    public int getConnectionMask(int side) {
        return 16;
    }

    @Override
    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
        super.maskChangeEvent(internalChange, externalChange);
        RedstonePropagator.logCalculation();
        RedstonePropagator.propagateTo((IPropagationPart)this, (int)(internalChange || externalChange ? 2 : 0));
    }

    public boolean canConnectPart(IConnectable part, int dir) {
        if (!this.hasRedstone) {
            return false;
        }
        if (part instanceof MaskedRedstonePart) {
            MaskedRedstonePart mrp = (MaskedRedstonePart)part;
            return (mrp.getConnectionMask(dir ^ 1) & 0x10) != 0;
        }
        if (part instanceof RedstonePart) {
            RedstonePart rp = (RedstonePart)part;
            return rp.canConnectRedstone(dir ^ 1);
        }
        return part instanceof IRedwirePart;
    }

    public boolean discoverStraightOverride(int s) {
        if (!this.hasRedstone) {
            return false;
        }
        boolean prevCanConnectRW = RedstonePropagator.canConnectRedwires();
        RedstonePropagator.setCanConnectRedwires((boolean)false);
        boolean discovered = (RedstoneInteractions.otherConnectionMask((LevelReader)this.level(), (BlockPos)this.pos(), (int)s, (boolean)false) & RedstoneInteractions.connectionMask((MultiPart)this, (int)s)) != 0;
        RedstonePropagator.setCanConnectRedwires((boolean)prevCanConnectRW);
        return discovered;
    }

    public boolean discoverInternalOverride(int s) {
        if (!this.hasRedstone) {
            return false;
        }
        MultiPart part = this.tile().getSlottedPart(s);
        if (part instanceof RedstonePart) {
            return ((RedstonePart)part).canConnectRedstone(s ^ 1);
        }
        return false;
    }

    public int getSignal() {
        return this.signal & 0xFF;
    }

    public void setSignal(int signal) {
        this.signal = (byte)signal;
    }

    public void onSignalUpdate() {
        this.sendSignalUpdate();
    }

    public int calculateSignal() {
        if (!this.hasRedstone) {
            return 0;
        }
        RedstonePropagator.setDustProvidesPower((boolean)false);
        RedstonePropagator.setRedwiresProvidePower((boolean)false);
        int signal = 0;
        for (int s = 0; s < 6; ++s) {
            CenterLookup lookup;
            int sig = 0;
            if (this.maskConnectsIn(s)) {
                lookup = CenterLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)s);
                sig = this.resolveSignal(lookup);
            } else if (this.maskConnectsOut(s) && (sig = this.resolveSignal(lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)s))) == 0) {
                sig = RedstoneCenterLookup.resolveVanillaSignal((CenterLookup)lookup, (MultiPart)this);
            }
            signal = Math.max(sig, signal);
        }
        RedstonePropagator.setDustProvidesPower((boolean)true);
        RedstonePropagator.setRedwiresProvidePower((boolean)true);
        return signal;
    }

    public void propagateOther(int mode) {
        for (int s = 0; s < 6; ++s) {
            if (this.maskConnects(s)) continue;
            RedstonePropagator.addNeighborChange((Level)this.level(), (BlockPos)this.pos(), (BlockPos)this.posOfStraight(s));
        }
    }

    public int getRedwireSignal(int dir) {
        return this.getSignal();
    }

    public boolean diminishOnSide(int side) {
        return true;
    }

    protected int resolveSignal(CenterLookup lookup) {
        return RedstoneCenterLookup.resolveSignal((CenterLookup)lookup, (boolean)true);
    }
}

