/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.expansion.MovementManager;
import mrtjp.projectred.expansion.MovementRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FrameStickResolver {
    private final Level level;
    private final BlockPos start;
    private final Set<BlockPos> exclusions;
    private final LinkedList<BlockPos> open = new LinkedList();
    private final Set<BlockPos> closed = new HashSet<BlockPos>();

    public FrameStickResolver(Level level, BlockPos start, Set<BlockPos> exclusions) {
        this.level = level;
        this.start = start;
        this.exclusions = exclusions;
    }

    public Set<BlockPos> resolve() {
        this.open.clear();
        this.closed.clear();
        this.open.addLast(this.start);
        while (!this.open.isEmpty()) {
            this.checkNext();
        }
        return this.closed;
    }

    private void checkNext() {
        BlockPos next = this.open.removeFirst();
        Set<BlockPos> nextSticks = this.getNextSticks(next);
        for (BlockPos stick : nextSticks) {
            if (this.closed.contains(stick) || this.exclusions.contains(stick) || this.open.contains(stick)) continue;
            this.open.addLast(stick);
        }
        this.closed.add(next);
    }

    private Set<BlockPos> getNextSticks(BlockPos source) {
        Frame frame = MovementRegistry.getFrame(this.level, source);
        if (frame == null) {
            return Collections.emptySet();
        }
        HashSet<BlockPos> stuckBlocks = new HashSet<BlockPos>();
        for (int s = 0; s < 6; ++s) {
            Frame stuckFrame;
            Direction dir = Direction.values()[s];
            if (!frame.canGrab(this.level, source, dir)) continue;
            BlockPos stuckBlockPos = source.m_121945_(dir);
            BlockState stuckBlockState = this.level.m_8055_(stuckBlockPos);
            if (this.level.m_46859_(stuckBlockPos) || stuckBlockState.m_60795_() || MovementManager.getInstance(this.level).getMovementInfo(stuckBlockPos).isMoving() || (stuckFrame = MovementRegistry.getFrame(this.level, stuckBlockPos)) != null && !stuckFrame.canBeGrabbed(this.level, stuckBlockPos, dir.m_122424_())) continue;
            stuckBlocks.add(stuckBlockPos);
        }
        stuckBlocks.addAll(frame.getAdditionalSticks());
        return stuckBlocks;
    }
}

