/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonEntry
extends Button {
    private static final int ANIM_TIME = 5;
    private final GuiBook parent;
    private final BookEntry entry;
    private float timeHovered;

    public GuiButtonEntry(GuiBook parent, int x, int y, BookEntry entry, Button.OnPress onPress) {
        super(x, y, 116, 10, (Component)entry.getName(), onPress, f_252438_);
        this.parent = parent;
        this.entry = entry;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent name;
        if (!this.f_93623_) {
            return;
        }
        this.timeHovered = this.m_198029_() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
        float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.m_198029_() ? partialTicks : -partialTicks)));
        float widthFract = time / 5.0f;
        boolean locked = this.entry.isLocked();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        graphics.m_280509_(this.m_252754_() * 2, this.m_252907_() * 2, (this.m_252754_() + (int)((float)this.f_93618_ * widthFract)) * 2, (this.m_252907_() + this.f_93619_) * 2, 0x22000000);
        RenderSystem.enableBlend();
        if (locked) {
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 0.7f);
            GuiBook.drawLock(graphics, this.parent.book, this.m_252754_() * 2 + 2, this.m_252907_() * 2 + 2);
        } else {
            this.entry.getIcon().render(graphics, this.m_252754_() * 2 + 2, this.m_252907_() * 2 + 2);
        }
        graphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
        if (locked) {
            name = Component.m_237115_((String)"patchouli.gui.lexicon.locked");
        } else {
            name = this.entry.getName();
            if (this.entry.isPriority()) {
                name = name.m_130940_(ChatFormatting.ITALIC);
            }
        }
        name = name.m_130948_(this.entry.getBook().getFontStyle());
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)name, this.m_252754_() + 12, this.m_252907_(), this.getColor(), false);
        if (!this.entry.isLocked()) {
            GuiBook.drawMarking(graphics, this.parent.book, this.m_252754_() + this.f_93618_ - 5, this.m_252907_() + 1, this.entry.hashCode(), this.entry.getReadState());
        }
    }

    private int getColor() {
        if (this.entry.isSecret()) {
            return 0xAA000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        if (this.entry.isLocked()) {
            return 0x77000000 | this.parent.book.textColor & 0xFFFFFF;
        }
        return this.entry.getEntryColor();
    }

    public void m_7435_(SoundManager soundHandlerIn) {
        if (this.entry != null && !this.entry.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }
}

