/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.lib.radial.data.NestingRadialData;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.items.ModuleWeaponAttackAmplificationUnit;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekaTana
extends ItemEnergized
implements IModuleContainerItem,
IGenericRadialModeItem {
    private static final ResourceLocation RADIAL_ID = MekaWeapons.rl("mekatana");
    private final Int2ObjectMap<AttributeCache> attributeCaches = new Int2ObjectArrayMap(ModuleWeaponAttackAmplificationUnit.AttackDamage.values().length - 2);

    public ItemMekaTana(@NotNull Item.Properties properties) {
        super((FloatingLongSupplier)MekaWeapons.general.mekaTanaBaseChargeRate, (FloatingLongSupplier)MekaWeapons.general.mekaTanaBaseEnergyCapacity, properties.m_41497_(Rarity.EPIC).setNoRepair().m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack stack, @NotNull Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
            return;
        }
        StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
        tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()}));
    }

    public void adjustAttributes(@NotNull ItemAttributeModifierEvent event) {
        long totalDamage = MekaWeaponsUtils.getTotalDamage(event.getItemStack());
        event.addModifier(Attributes.f_22281_, new AttributeModifier(f_41374_, "Weapon modifier", (double)totalDamage, AttributeModifier.Operation.ADDITION));
    }

    public boolean m_7579_(@Nonnull @NotNull ItemStack stack, @Nonnull @NotNull LivingEntity target, @Nonnull @NotNull LivingEntity attacker) {
        Player player;
        if (attacker instanceof Player && !(player = (Player)attacker).m_7500_()) {
            long energyNeeded = MekaWeaponsUtils.getEnergyNeeded(stack);
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
            if (energyContainer != null) {
                energyContainer.extract(FloatingLong.create((long)energyNeeded), Action.EXECUTE, AutomationType.MANUAL);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            FloatingLong energy;
            IModule attackAmplificationUnit = this.getModule(stack, (IModuleDataProvider)MekaWeapons.ATTACKAMPLIFICATION_UNIT);
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
            FloatingLong floatingLong = energy = energyContainer != null ? energyContainer.getEnergy() : FloatingLong.ZERO;
            int unitDamage = energy.greaterOrEqual((FloatingLong)MekaWeapons.general.mekaTanaEnergyUsage.get()) ? (attackAmplificationUnit != null ? ((ModuleWeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit() : 1) : 0;
            long totalDamage = MekaWeaponsUtils.getTotalDamage(stack);
            return (Multimap)((AttributeCache)this.attributeCaches.computeIfAbsent(unitDamage, damage -> new AttributeCache(builder -> {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)totalDamage, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MekaWeapons.general.mekaTanaAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
            }, new CachedValue[]{MekaWeapons.general.mekaTanaBaseDamage, MekaWeapons.general.mekaTanaAttackSpeed}))).get();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull @NotNull Level world, @Nonnull @NotNull Player player, @Nonnull @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        IModule module = MekaWeaponsUtils.getEnabledModule(stack, MekanismModules.TELEPORTATION_UNIT);
        if (module == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockHitResult result = MekanismUtils.rayTrace((Player)player, (double)MekaWeapons.general.mekaTanaMaxTeleportReach.get());
        if (((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() && result.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = result.m_82425_();
        if (!this.isValidDestination(world, pos)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        double distance = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (distance < 5.0) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        FloatingLong energyNeeded = ((FloatingLong)MekaWeapons.general.mekaTanaTeleportUsage.get()).multiply(distance / 10.0);
        if (energyContainer == null || energyContainer.getEnergy().compareTo(energyNeeded) < 0) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return this.teleportPlayer(world, player, stack, pos, energyContainer, energyNeeded, result);
    }

    private boolean isValidDestination(@NotNull Level world, @NotNull BlockPos pos) {
        return this.isValidDestinationBlock(world, pos.m_7494_()) && this.isValidDestinationBlock(world, pos.m_6630_(2));
    }

    private boolean isValidDestinationBlock(@NotNull Level world, @NotNull BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60795_() || MekanismUtils.isLiquidBlock((Block)blockState.m_60734_());
    }

    private InteractionResultHolder<ItemStack> teleportPlayer(Level world, Player player, ItemStack stack, @NotNull BlockPos pos, IEnergyContainer energyContainer, FloatingLong energyNeeded, BlockHitResult result) {
        double targetZ;
        double targetY;
        double targetX = (double)pos.m_123341_() + 0.5;
        MekanismTeleportEvent.MekaTool event = new MekanismTeleportEvent.MekaTool(player, targetX, targetY = (double)pos.m_123342_() + 1.5, targetZ = (double)pos.m_123343_() + 0.5, stack, result);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
        if (player.m_20159_()) {
            player.m_142098_(targetX, targetY, targetZ);
        } else {
            player.m_6021_(targetX, targetY, targetZ);
        }
        player.m_183634_();
        Mekanism.packetHandler().sendToAllTracking((Object)new PacketPortalFX(pos.m_7494_()), world, pos);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return MekaWeaponsUtils.getBarCustomColor(stack);
    }

    public boolean m_8120_(@Nonnull @NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public ResourceLocation getRadialIdentifier() {
        return RADIAL_ID;
    }

    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return super.supportsSlotType(stack, slotType) && this.getModules(stack).stream().anyMatch(Module::handlesAnyModeChange);
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChange);
            return;
        }
    }

    @Nullable
    public RadialData<?> getRadialData(ItemStack stack) {
        ArrayList nestedModes = new ArrayList();
        Consumer<NestedRadialMode> adder = nestedModes::add;
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange()) continue;
            module.addRadialModes(stack, adder);
        }
        if (nestedModes.isEmpty()) {
            return null;
        }
        if (nestedModes.size() == 1) {
            return ((NestedRadialMode)nestedModes.get(0)).nestedData();
        }
        return new NestingRadialData(RADIAL_ID, nestedModes);
    }

    @Nullable
    public <M extends IRadialMode> M getMode(ItemStack stack, RadialData<M> radialData) {
        for (Module module : this.getModules(stack)) {
            IRadialMode mode;
            if (!module.handlesRadialModeChange() || (mode = module.getMode(stack, radialData)) == null) continue;
            return (M)mode;
        }
        return null;
    }

    public <M extends IRadialMode> void setMode(ItemStack stack, Player player, RadialData<M> radialData, M mode) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange() || !module.setMode(player, stack, radialData, mode)) continue;
            return;
        }
    }

    @Nullable
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return this.getModules(stack).stream().filter(Module::handlesModeChange).findFirst().map(module -> module.getModeScrollComponent(stack)).orElse(null);
    }
}

