/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import java.util.Collections;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.lib.multiblock.IMultiblockEjector;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityTurbineValve
extends TileEntityTurbineCasing
implements IMultiblockEjector {
    private Set<Direction> outputDirections = Collections.emptySet();

    public TileEntityTurbineValve(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.TURBINE_VALVE, pos, state);
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        return side -> ((TurbineMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return side -> ((TurbineMultiblockData)this.getMultiblock()).getEnergyContainers(side);
    }

    protected boolean onUpdateServer(TurbineMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        if (multiblock.isFormed()) {
            CableUtils.emit(this.outputDirections, (IEnergyContainer)multiblock.energyContainer, (BlockEntity)this);
        }
        return needsPacket;
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    public void setEjectSides(Set<Direction> sides) {
        this.outputDirections = sides;
    }

    public int getRedstoneLevel() {
        return ((TurbineMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }
}

