/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.config;

import java.util.function.Predicate;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.config.value.CachedResourceLocationListValue;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class GeneratorsConfig
extends BaseMekanismConfig {
    private static final String TURBINE_CATEGORY = "turbine";
    private static final String WIND_CATEGORY = "wind_generator";
    private static final String BIO_CATEGORY = "bio_generator";
    private static final String HEAT_CATEGORY = "heat_generator";
    private static final String GAS_CATEGORY = "gas_generator";
    private static final String HOHLRAUM_CATEGORY = "hohlraum";
    private static final String FUSION_CATEGORY = "fusion_reactor";
    private static final String FISSION_CATEGORY = "fission_reactor";
    private final ForgeConfigSpec configSpec;
    public final CachedFloatingLongValue advancedSolarGeneration;
    public final CachedFloatingLongValue bioGeneration;
    public final CachedIntValue bioTankCapacity;
    public final CachedFloatingLongValue heatGeneration;
    public final CachedFloatingLongValue heatGenerationLava;
    public final CachedFloatingLongValue heatGenerationNether;
    public final CachedIntValue heatTankCapacity;
    public final CachedIntValue heatGenerationFluidRate;
    public final CachedLongValue gbgTankCapacity;
    public final CachedIntValue ethyleneBurnTicks;
    public final CachedFloatingLongValue ethyleneDensityMultiplier;
    public final CachedFloatingLongValue solarGeneration;
    public final CachedIntValue turbineBladesPerCoil;
    public final CachedDoubleValue turbineVentGasFlow;
    public final CachedDoubleValue turbineDisperserGasFlow;
    public final CachedFloatingLongValue turbineEnergyCapacityPerVolume;
    public final CachedLongValue turbineGasPerTank;
    public final CachedIntValue condenserRate;
    public final CachedFloatingLongValue energyPerFusionFuel;
    public final CachedFloatingLongValue windGenerationMin;
    public final CachedFloatingLongValue windGenerationMax;
    public final CachedIntValue windGenerationMinY;
    public final CachedIntValue windGenerationMaxY;
    public final CachedResourceLocationListValue windGenerationDimBlacklist;
    public final CachedFloatingLongValue energyPerFissionFuel;
    public final CachedDoubleValue fissionCasingHeatCapacity;
    public final CachedDoubleValue fissionSurfaceAreaTarget;
    public final CachedBooleanValue fissionMeltdownsEnabled;
    public final CachedFloatValue fissionMeltdownRadius;
    public final CachedDoubleValue fissionMeltdownChance;
    public final CachedDoubleValue fissionMeltdownRadiationMultiplier;
    public final CachedDoubleValue fissionPostMeltdownDamage;
    public final CachedDoubleValue defaultBurnRate;
    public final CachedLongValue burnPerAssembly;
    public final CachedLongValue maxFuelPerAssembly;
    public final CachedIntValue fissionCooledCoolantPerTank;
    public final CachedLongValue fissionHeatedCoolantPerTank;
    public final CachedLongValue hohlraumMaxGas;
    public final CachedLongValue hohlraumFillRate;
    public final CachedDoubleValue fusionThermocoupleEfficiency;
    public final CachedDoubleValue fusionCasingThermalConductivity;
    public final CachedDoubleValue fusionWaterHeatingRatio;
    public final CachedLongValue fusionFuelCapacity;
    public final CachedFloatingLongValue fusionEnergyCapacity;
    public final CachedIntValue fusionWaterPerInjection;
    public final CachedLongValue fusionSteamPerInjection;

    GeneratorsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Generators Config. This config is synced between server and client.").push("generators");
        this.energyPerFusionFuel = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Affects the Injection Rate, Max Temp, and Ignition Temp.", (String)"energyPerFusionFuel", (FloatingLong)FloatingLong.createConst((long)10000000L));
        this.solarGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Peak output for the Solar Generator. Note: It can go higher than this value in some extreme environments.", (String)"solarGeneration", (FloatingLong)FloatingLong.createConst((long)50L));
        this.advancedSolarGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Peak output for the Advanced Solar Generator. Note: It can go higher than this value in some extreme environments.", (String)"advancedSolarGeneration", (FloatingLong)FloatingLong.createConst((long)300L));
        builder.comment("Bio Generator Settings").push(BIO_CATEGORY);
        this.bioGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy in Joules the Bio Generator produces per tick.", (String)"bioGeneration", (FloatingLong)FloatingLong.createConst((long)350L));
        this.bioTankCapacity = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The capacity in mB of the fluid tank in the Bio Generator.").defineInRange("tankCapacity", 24000, 1, Integer.MAX_VALUE));
        builder.pop();
        builder.comment("Heat Generator Settings").push(HEAT_CATEGORY);
        this.heatGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy in Joules the Heat Generator produces per tick. heatGeneration + heatGenerationLava * lavaSides + heatGenerationNether. Note: lavaSides is how many sides are adjacent to lava, this includes the block itself if it is lava logged allowing for a max of 7 \"sides\".", (String)"heatGeneration", (FloatingLong)FloatingLong.createConst((long)200L));
        this.heatGenerationLava = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Multiplier of effectiveness of Lava that is adjacent to the Heat Generator.", (String)"heatGenerationLava", (FloatingLong)FloatingLong.createConst((long)30L));
        this.heatGenerationNether = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Add this amount of Joules to the energy produced by a heat generator if it is in an 'ultrawarm' dimension, in vanilla this is just the Nether.", (String)"heatGenerationNether", (FloatingLong)FloatingLong.createConst((long)100L));
        this.heatTankCapacity = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The capacity in mB of the fluid tank in the Heat Generator.").defineInRange("tankCapacity", 24000, 1, Integer.MAX_VALUE));
        this.heatGenerationFluidRate = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The amount of lava in mB that gets consumed to transfer heatGeneration Joules to the Heat Generator.").define("heatGenerationFluidRate", (Object)10, value -> {
            Integer i;
            return value instanceof Integer && (i = (Integer)value) > 0 && i <= this.heatTankCapacity.get();
        }));
        builder.pop();
        builder.comment("Gas-Burning Generator Settings").push(GAS_CATEGORY);
        this.gbgTankCapacity = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The capacity in mB of the gas tank in the Gas-Burning Generator.").defineInRange("tankCapacity", 18000L, 1L, Long.MAX_VALUE));
        this.ethyleneBurnTicks = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The number of ticks each mB of Ethylene burns for in the Gas-Burning Generator.").defineInRange("ethyleneBurnTicks", 40, 1, Integer.MAX_VALUE));
        this.ethyleneDensityMultiplier = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Multiplier for calculating the energy density of Ethylene (1 mB Hydrogen + 2 * bioGeneration * densityMultiplier).", (String)"ethyleneDensityMultiplier", (FloatingLong)FloatingLong.createConst((long)40L), (Predicate)CachedFloatingLongValue.POSITIVE);
        builder.pop();
        builder.comment("Turbine Settings").push(TURBINE_CATEGORY);
        this.turbineBladesPerCoil = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The number of blades on each turbine coil per blade applied.").defineInRange("turbineBladesPerCoil", 4, 1, 12));
        this.turbineVentGasFlow = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The rate at which steam is vented into the turbine.").defineInRange("turbineVentGasFlow", 32000.0, 0.1, 1024000.0));
        this.turbineDisperserGasFlow = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The rate at which steam is dispersed into the turbine.").defineInRange("turbineDisperserGasFlow", 1280.0, 0.1, 1024000.0));
        this.turbineEnergyCapacityPerVolume = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy (J) that each block of the turbine contributes to the total energy capacity. Max = volume * energyCapacityPerVolume", (String)"energyCapacityPerVolume", (FloatingLong)FloatingLong.createConst((long)16000000L), (Predicate)CachedFloatingLongValue.greaterZeroLessThan((FloatingLong)FloatingLong.createConst((long)1000000000000L)));
        int maxTurbine = 5202;
        this.turbineGasPerTank = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of gas (mB) that each block of the turbine's steam cavity contributes to the volume. Max = volume * gasPerTank").defineInRange("gasPerTank", 64000L, 1L, Long.MAX_VALUE / (long)maxTurbine));
        this.condenserRate = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The rate at which steam is condensed in the turbine.").defineInRange("condenserRate", 64000, 1, 2000000));
        builder.pop();
        builder.comment("Wind Generator Settings").push(WIND_CATEGORY);
        this.windGenerationMin = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Minimum base generation value of the Wind Generator.", (String)"windGenerationMin", (FloatingLong)FloatingLong.createConst((long)60L));
        this.windGenerationMax = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Maximum base generation value of the Wind Generator.", (String)"generationMax", (FloatingLong)FloatingLong.createConst((long)480L));
        this.windGenerationMinY = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The minimum Y value that affects the Wind Generators Power generation. This value gets clamped at the world's min height.").defineInRange("minY", 24, DimensionType.f_156653_, DimensionType.f_156652_ - 1));
        this.windGenerationMaxY = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The maximum Y value that affects the Wind Generators Power generation. This value gets clamped at the world's logical height.").define("maxY", (Object)DimensionType.f_156652_, value -> value instanceof Integer && (Integer)value > this.windGenerationMinY.get()));
        this.windGenerationDimBlacklist = CachedResourceLocationListValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder.comment("The list of dimension ids that the Wind Generator will not generate power in."), (String)"windGenerationDimBlacklist", (Predicate)ConstantPredicates.alwaysTrue());
        builder.pop();
        builder.comment("Fusion Settings").push(FUSION_CATEGORY);
        this.fusionThermocoupleEfficiency = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The fraction of the heat dissipated from the case that is converted to Joules.").defineInRange("thermocoupleEfficiency", 0.05, 0.0, 1.0));
        this.fusionCasingThermalConductivity = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The fraction fraction of heat from the casing that can be transferred to all sources that are not water. Will impact max heat, heat transfer to thermodynamic conductors, and power generation.").defineInRange("casingThermalConductivity", 0.1, 0.001, 1.0));
        this.fusionWaterHeatingRatio = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The fraction of the heat from the casing that is dissipated to water when water cooling is in use. Will impact max heat, and steam generation.").defineInRange("waterHeatingRatio", 0.3, 0.0, 1.0));
        this.fusionFuelCapacity = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of fuel (mB) that the fusion reactor can store.").defineInRange("fuelCapacity", 1000L, 2L, 1000000L));
        this.fusionEnergyCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy (J) the fusion reactor can store.", (String)"energyCapacity", (FloatingLong)FloatingLong.createConst((long)1000000000L), (Predicate)CachedFloatingLongValue.POSITIVE);
        int baseMaxWater = 1000000;
        this.fusionWaterPerInjection = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of water (mB) per injection rate that the fusion reactor can store. Max = injectionRate * waterPerInjection").defineInRange("waterPerInjection", 1000000, 1, 21913098));
        this.fusionSteamPerInjection = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of steam (mB) per injection rate that the fusion reactor can store. Max = injectionRate * steamPerInjection").defineInRange("steamPerInjection", 100L * (long)baseMaxWater, 1L, 94116041192395671L));
        builder.pop();
        builder.comment("Hohlraum Settings").push(HOHLRAUM_CATEGORY);
        this.hohlraumMaxGas = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Hohlraum capacity in mB.").defineInRange("maxGas", 10L, 1L, Long.MAX_VALUE));
        this.hohlraumFillRate = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of DT-Fuel Hohlraum can accept per tick.").defineInRange("fillRate", 1L, 1L, Long.MAX_VALUE));
        builder.pop();
        builder.comment("Fission Reactor Settings").push(FISSION_CATEGORY);
        this.energyPerFissionFuel = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy created (in heat) from each whole mB of fission fuel.", (String)"energyPerFissionFuel", (FloatingLong)FloatingLong.createConst((long)1000000L));
        this.fissionCasingHeatCapacity = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The heat capacity added to a Fission Reactor by a single casing block. Increase to require more energy to raise the reactor temperature.").defineInRange("casingHeatCapacity", 1000.0, 1.0, 1000000.0));
        this.fissionSurfaceAreaTarget = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The average surface area of a Fission Reactor's fuel assemblies to reach 100% boil efficiency. Higher values make it harder to cool the reactor.").defineInRange("surfaceAreaTarget", 4.0, 1.0, Double.MAX_VALUE));
        this.fissionMeltdownsEnabled = CachedBooleanValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Whether catastrophic meltdowns can occur from Fission Reactors. If disabled instead of melting down the reactor will turn off and not be able to be turned back on until the damage level decreases.").define("meltdownsEnabled", true));
        this.fissionMeltdownRadius = CachedFloatValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The radius of the explosion that occurs from a meltdown.").defineInRange("meltdownRadius", 8.0, 1.0, 500.0));
        this.fissionMeltdownChance = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The chance of a meltdown occurring once damage passes 100%. Will linearly scale as damage continues increasing.").defineInRange("meltdownChance", 0.001, 0.0, 1.0));
        this.fissionMeltdownRadiationMultiplier = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("How much radioactivity of fuel/waste contents are multiplied during a meltdown.").defineInRange("meltdownRadiationMultiplier", 50.0, 0.1, 1000000.0));
        this.fissionPostMeltdownDamage = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Damage to reset the reactor to after a meltdown.").defineInRange("postMeltdownDamage", 75.0, 0.0, 100.0));
        this.defaultBurnRate = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The default burn rate of the fission reactor.").defineInRange("defaultBurnRate", 0.1, 0.001, 1.0));
        this.burnPerAssembly = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The burn rate increase each fuel assembly provides. Max Burn Rate = fuelAssemblies * burnPerAssembly").defineInRange("burnPerAssembly", 1L, 1L, 1000000L));
        this.maxFuelPerAssembly = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of fuel (mB) that each assembly contributes to the fuel and waste capacity. Max = fuelAssemblies * maxFuelPerAssembly").defineInRange("maxFuelPerAssembly", 8000L, 1L, 0x7FFFFFFFFFFFFL));
        int maxVolume = 5832;
        this.fissionCooledCoolantPerTank = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of cooled coolant (mB) that each block of the fission reactor contributes to the volume. Max = volume * cooledCoolantPerTank").defineInRange("cooledCoolantPerTank", 100000, 1, Integer.MAX_VALUE / maxVolume));
        this.fissionHeatedCoolantPerTank = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of heated coolant (mB) that each block of the fission reactor contributes to the volume. Max = volume * heatedCoolantPerTank").defineInRange("heatedCoolantPerTank", 1000000L, 1000L, Long.MAX_VALUE / (long)maxVolume));
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "generators";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

