/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.obelisk;

import com.enderio.core.common.util.ChunkBoundLookup;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.blockentity.base.ObeliskBlockEntity;
import com.enderio.machines.common.obelisk.IObeliskManagerCapability;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public abstract class ObeliskManager<T extends ObeliskBlockEntity>
implements IObeliskManagerCapability<T> {
    private final ChunkBoundLookup<T> lookup = new ChunkBoundLookup();

    @Override
    public void register(T obelisk) {
        this.lookup.addForBlockRadius(obelisk.m_58899_(), ((MachineBlockEntity)obelisk).getRange(), obelisk);
    }

    @Override
    public void unregister(T obelisk) {
        this.lookup.remove(obelisk);
    }

    @Override
    public void update(T obelisk) {
        this.lookup.updateForBlockRadius(obelisk.m_58899_(), ((MachineBlockEntity)obelisk).getRange(), obelisk);
    }

    @Override
    @Nullable
    public Set<T> getObelisksFor(BlockPos pos) {
        return this.lookup.getForChunk(new ChunkPos(pos));
    }
}

