/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.network;

import com.enderio.core.common.network.Packet;
import com.enderio.machines.common.souldata.EngineSoul;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SoulEngineSoulPacket
implements Packet {
    private final Map<ResourceLocation, EngineSoul.SoulData> map;

    public SoulEngineSoulPacket(Map<ResourceLocation, EngineSoul.SoulData> map) {
        this.map = map;
    }

    public SoulEngineSoulPacket(FriendlyByteBuf buf) {
        this.map = buf.m_236847_(FriendlyByteBuf::m_130281_, buff -> new EngineSoul.SoulData(buff.m_130281_(), buff.m_130277_(), buff.readInt(), buff.readInt()));
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_236831_(this.map, FriendlyByteBuf::m_130085_, (buf, soulData) -> {
            buf.m_130085_(soulData.entitytype());
            buf.m_130070_(soulData.fluid());
            buf.writeInt(soulData.powerpermb());
            buf.writeInt(soulData.tickpermb());
        });
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            EngineSoul.ENGINE.map = this.map;
        });
        context.setPacketHandled(true);
    }

    public static class Handler
    extends Packet.PacketHandler<SoulEngineSoulPacket> {
        @Override
        public SoulEngineSoulPacket fromNetwork(FriendlyByteBuf buf) {
            return new SoulEngineSoulPacket(buf);
        }

        @Override
        public void toNetwork(SoulEngineSoulPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

