/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.item;

import com.enderio.base.common.capacitor.CapacitorUtil;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import net.minecraft.world.item.ItemStack;

public class MachineInventoryLayout {
    private final List<SlotConfig> slots;
    private final int capacitorSlot;

    private MachineInventoryLayout(Builder builder) {
        this.slots = List.copyOf(builder.slots);
        this.capacitorSlot = builder.capacitorSlot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getSlotCount() {
        return this.slots.size();
    }

    public boolean supportsCapacitor() {
        return this.capacitorSlot >= 0;
    }

    public int getCapacitorSlot() {
        return this.capacitorSlot;
    }

    public int getStackLimit(int slot) {
        return this.slots.get((int)slot).stackLimit;
    }

    public boolean canInsert(int slot) {
        return this.slots.get((int)slot).insert;
    }

    public boolean canExtract(int slot) {
        return this.slots.get((int)slot).extract;
    }

    public boolean guiCanInsert(int slot) {
        return this.slots.get((int)slot).guiInsert;
    }

    public boolean guiCanExtract(int slot) {
        return this.slots.get((int)slot).guiExtract;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.slots.get((int)slot).filter.test(slot, stack);
    }

    public static class Builder {
        private final ArrayList<SlotConfig> slots = new ArrayList();
        private int currentStackLimit = 64;
        private int capacitorSlot = -1;
        private SlotAdditionInfo additionInfo = new SlotAdditionInfo(Integer.MIN_VALUE, Integer.MIN_VALUE);

        public Builder slot(UnaryOperator<SlotBuilder> builder) {
            this.additionInfo = new SlotAdditionInfo(this.slots.size(), 1);
            this.slots.add(((SlotBuilder)builder.apply(new SlotBuilder())).build());
            return this;
        }

        public Builder setStackLimit(int limit) {
            this.currentStackLimit = limit;
            return this;
        }

        public Builder inputSlot() {
            return this.inputSlot(1, (i, s) -> true);
        }

        public Builder inputSlot(int count) {
            return this.inputSlot(count, (i, s) -> true);
        }

        public Builder inputSlot(BiPredicate<Integer, ItemStack> filter) {
            return this.inputSlot(1, filter);
        }

        public Builder inputSlot(int count, BiPredicate<Integer, ItemStack> filter) {
            SlotAdditionInfo info = new SlotAdditionInfo(this.slots.size(), count);
            for (int i = 0; i < count; ++i) {
                this.slot(slot -> slot.guiInsert().guiExtract().insert().filter(filter).stackLimit(this.currentStackLimit));
            }
            this.additionInfo = info;
            return this;
        }

        public Builder outputSlot() {
            return this.outputSlot(1, (i, s) -> true);
        }

        public Builder outputSlot(int count) {
            return this.outputSlot(count, (i, s) -> true);
        }

        public Builder outputSlot(BiPredicate<Integer, ItemStack> filter) {
            return this.outputSlot(1, filter);
        }

        public Builder outputSlot(int count, BiPredicate<Integer, ItemStack> filter) {
            SlotAdditionInfo info = new SlotAdditionInfo(this.slots.size(), count);
            for (int i = 0; i < count; ++i) {
                this.slot(slot -> slot.guiExtract().extract().filter(filter).stackLimit(this.currentStackLimit));
            }
            this.additionInfo = info;
            return this;
        }

        public Builder storageSlot() {
            return this.storageSlot(1, (i, s) -> true);
        }

        public Builder storageSlot(int count) {
            return this.storageSlot(count, (i, s) -> true);
        }

        public Builder storageSlot(BiPredicate<Integer, ItemStack> filter) {
            return this.storageSlot(1, filter);
        }

        public Builder storageSlot(int count, BiPredicate<Integer, ItemStack> filter) {
            SlotAdditionInfo info = new SlotAdditionInfo(this.slots.size(), count);
            for (int i = 0; i < count; ++i) {
                this.slot(slot -> slot.guiInsert().guiExtract().insert().extract().filter(filter).stackLimit(this.currentStackLimit));
            }
            this.additionInfo = info;
            return this;
        }

        public Builder ghostSlot() {
            return this.ghostSlot(1, (i, s) -> true);
        }

        public Builder ghostSlot(int count) {
            return this.ghostSlot(count, (i, s) -> true);
        }

        public Builder ghostSlot(BiPredicate<Integer, ItemStack> filter) {
            return this.ghostSlot(1, filter);
        }

        public Builder ghostSlot(int count, BiPredicate<Integer, ItemStack> filter) {
            SlotAdditionInfo info = new SlotAdditionInfo(this.slots.size(), count);
            for (int i = 0; i < count; ++i) {
                this.slot(slot -> slot.guiInsert().filter(filter).stackLimit(this.currentStackLimit));
            }
            this.additionInfo = info;
            return this;
        }

        public Builder previewSlot() {
            return this.previewSlot(1);
        }

        public Builder previewSlot(int count) {
            SlotAdditionInfo info = new SlotAdditionInfo(this.slots.size(), count);
            for (int i = 0; i < count; ++i) {
                this.slot(slot -> slot.stackLimit(this.currentStackLimit));
            }
            this.additionInfo = info;
            return this;
        }

        public Builder capacitor() {
            if (this.capacitorSlot >= 0) {
                throw new IllegalStateException("A machine inventory may not have more than one capacitor slot!");
            }
            this.slot(slot -> slot.guiInsert().guiExtract().filter((i, s) -> CapacitorUtil.isCapacitor(s)).stackLimit(1));
            this.capacitorSlot = this.slots.size() - 1;
            return this;
        }

        public Builder slotAccess(SingleSlotAccess access) {
            if (this.additionInfo.size != 1) {
                throw new IllegalStateException("try to get a single slot access for multiple slots");
            }
            access.init(this.additionInfo.index);
            return this;
        }

        public Builder slotAccess(MultiSlotAccess multiSlotAccess) {
            if (this.additionInfo.size <= 1) {
                throw new IllegalStateException("try to get multi slot access for a single slot");
            }
            multiSlotAccess.init(this.additionInfo.index, this.additionInfo.size);
            return this;
        }

        public MachineInventoryLayout build() {
            return new MachineInventoryLayout(this);
        }

        public static class SlotBuilder {
            private boolean insert;
            private boolean extract;
            private boolean guiInsert;
            private boolean guiExtract;
            private int stackLimit = 64;
            private BiPredicate<Integer, ItemStack> filter = (i, s) -> true;

            private SlotBuilder() {
            }

            public SlotBuilder insert() {
                this.insert = true;
                return this;
            }

            public SlotBuilder extract() {
                this.extract = true;
                return this;
            }

            public SlotBuilder guiInsert() {
                this.guiInsert = true;
                return this;
            }

            public SlotBuilder guiExtract() {
                this.guiExtract = true;
                return this;
            }

            public SlotBuilder filter(BiPredicate<Integer, ItemStack> filter) {
                this.filter = filter;
                return this;
            }

            public SlotBuilder stackLimit(int limit) {
                this.stackLimit = Math.max(Math.min(limit, 64), 0);
                return this;
            }

            private SlotConfig build() {
                return new SlotConfig(this.insert, this.extract, this.guiInsert, this.guiExtract, this.stackLimit, this.filter);
            }
        }
    }

    private record SlotConfig(boolean insert, boolean extract, boolean guiInsert, boolean guiExtract, int stackLimit, BiPredicate<Integer, ItemStack> filter) {
    }

    private record SlotAdditionInfo(int index, int size) {
    }
}

