/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.fluid;

import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.TankAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;

public class MachineTankLayout {
    private final List<TankConfig> tanks;

    private MachineTankLayout(Builder builder) {
        this.tanks = List.copyOf(builder.tanks);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getTankCount() {
        return this.tanks.size();
    }

    public int getTankCapacity(int slot) {
        return this.tanks.get(slot).capacity();
    }

    public boolean canInsert(int slot) {
        return this.tanks.get(slot).insert();
    }

    public boolean canExtract(int slot) {
        return this.tanks.get(slot).extract();
    }

    public boolean isFluidValid(int slot, FluidStack stack) {
        return this.tanks.get(slot).filter().test(stack);
    }

    public List<MachineFluidTank> createTanks() {
        ArrayList<MachineFluidTank> tankList = new ArrayList<MachineFluidTank>();
        this.tanks.forEach(config -> tankList.add(new MachineFluidTank(config.capacity())));
        return tankList;
    }

    public static class Builder {
        private final ArrayList<TankConfig> tanks = new ArrayList();

        public Builder tank(TankAccess access, int capacity) {
            return this.tank(access, capacity, t -> true);
        }

        public Builder tank(TankAccess access, int capacity, Predicate<FluidStack> filter) {
            return this.tank(access, capacity, true, true, filter);
        }

        public Builder tank(TankAccess access, int capacity, boolean canInsert, boolean canExtract, Predicate<FluidStack> filter) {
            this.tanks.add(new TankConfig(capacity, canInsert, canExtract, filter));
            access.init(this.tanks.size() - 1);
            return this;
        }

        public MachineTankLayout build() {
            return new MachineTankLayout(this);
        }
    }

    private record TankConfig(int capacity, boolean insert, boolean extract, Predicate<FluidStack> filter) {
    }
}

