/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io;

import com.enderio.api.io.IOMode;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TransferUtil {
    public static final int DEFAULT_FLUID_DRAIN = 100;

    public static void distributeItems(IOMode mode, IItemHandler selfItemHandler, IItemHandler otherItemHandler) {
        TransferUtil.distributeItems(mode.canPush(), mode.canPull(), selfItemHandler, otherItemHandler);
    }

    public static void distributeItems(boolean canPush, boolean canPull, IItemHandler selfItemHandler, IItemHandler otherItemHandler) {
        if (canPush) {
            TransferUtil.moveItems(selfItemHandler, otherItemHandler);
        }
        if (canPull) {
            TransferUtil.moveItems(otherItemHandler, selfItemHandler);
        }
    }

    private static void moveItems(IItemHandler from, IItemHandler to) {
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack extracted = from.extractItem(i, 1, true);
            if (extracted.m_41619_()) continue;
            for (int j = 0; j < to.getSlots(); ++j) {
                ItemStack inserted = to.insertItem(j, extracted, false);
                if (!inserted.m_41619_()) continue;
                from.extractItem(i, 1, false);
                return;
            }
        }
    }

    public static void distributeFluids(IOMode mode, IFluidHandler selfItemHandler, IFluidHandler otherItemHandler) {
        TransferUtil.distributeFluids(mode.canPush(), mode.canPull(), selfItemHandler, otherItemHandler, 100);
    }

    public static void distributeFluids(IOMode mode, IFluidHandler selfItemHandler, IFluidHandler otherItemHandler, int maxDrain) {
        TransferUtil.distributeFluids(mode.canPush(), mode.canPull(), selfItemHandler, otherItemHandler, maxDrain);
    }

    public static void distributeFluids(boolean canPush, boolean canPull, IFluidHandler selfItemHandler, IFluidHandler otherItemHandler) {
        TransferUtil.distributeFluids(canPush, canPull, selfItemHandler, otherItemHandler, 100);
    }

    public static void distributeFluids(boolean canPush, boolean canPull, IFluidHandler selfItemHandler, IFluidHandler otherItemHandler, int maxDrain) {
        if (canPush) {
            int filled = 0;
            for (int i = 0; i < selfItemHandler.getTanks(); ++i) {
                filled += FluidUtil.tryFluidTransfer((IFluidHandler)otherItemHandler, (IFluidHandler)selfItemHandler, (FluidStack)new FluidStack(selfItemHandler.getFluidInTank(i), maxDrain), (boolean)true).getAmount();
            }
            if (filled > 0) {
                return;
            }
        }
        if (canPull) {
            for (int i = 0; i < selfItemHandler.getTanks(); ++i) {
                FluidUtil.tryFluidTransfer((IFluidHandler)selfItemHandler, (IFluidHandler)otherItemHandler, (FluidStack)new FluidStack(selfItemHandler.getFluidInTank(i), maxDrain), (boolean)true).getAmount();
            }
        }
    }
}

