/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.task.host;

import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.machines.common.blockentity.task.CraftingMachineTask;
import com.enderio.machines.common.blockentity.task.host.MachineTaskHost;
import com.enderio.machines.common.recipe.MachineRecipe;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CraftingMachineTaskHost<R extends MachineRecipe<C>, C extends Container>
extends MachineTaskHost {
    private final RecipeType<R> recipeType;
    private final C container;
    private final ICraftingMachineTaskFactory<? extends CraftingMachineTask<R, C>, R, C> taskFactory;

    public CraftingMachineTaskHost(EnderBlockEntity blockEntity, Supplier<Boolean> canAcceptNewTask, RecipeType<R> recipeType, C container, ICraftingMachineTaskFactory<? extends CraftingMachineTask<R, C>, R, C> taskFactory) {
        super(blockEntity, canAcceptNewTask);
        this.recipeType = recipeType;
        this.container = container;
        this.taskFactory = taskFactory;
    }

    public final C getContainer() {
        return this.container;
    }

    @Override
    @Nullable
    public CraftingMachineTask<R, C> getCurrentTask() {
        return (CraftingMachineTask)super.getCurrentTask();
    }

    @Override
    @Nullable
    protected CraftingMachineTask<R, C> getNewTask() {
        if (this.getLevel() == null) {
            return null;
        }
        return this.findRecipe().map(r -> this.taskFactory.createTask(this.getLevel(), this.container, (MachineRecipe)r)).orElse(null);
    }

    @Override
    @Nullable
    protected CraftingMachineTask<R, C> loadTask(CompoundTag nbt) {
        if (this.getLevel() == null) {
            return null;
        }
        CraftingMachineTask<R, C> task = this.taskFactory.createTask(this.getLevel(), this.container, null);
        task.deserializeNBT(nbt);
        return task;
    }

    @Override
    protected boolean shouldStartNewTask() {
        if (super.shouldStartNewTask()) {
            return true;
        }
        Optional<R> currentRecipe = this.findRecipe();
        return currentRecipe.map(r -> !r.equals(((CraftingMachineTask)this.getCurrentTask()).getRecipe())).orElse(true);
    }

    protected Optional<R> findRecipe() {
        Level level = this.getLevel();
        if (level == null) {
            return Optional.empty();
        }
        return level.m_7465_().m_44015_(this.recipeType, this.container, level);
    }

    public static interface ICraftingMachineTaskFactory<T extends CraftingMachineTask<R, C>, R extends MachineRecipe<C>, C extends Container> {
        public T createTask(Level var1, C var2, @Nullable R var3);
    }
}

