/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.network.Packet;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public abstract class ClientToServerMenuPacket<Menu extends AbstractContainerMenu>
implements Packet {
    private final int containerID;
    private final Class<Menu> menuClass;

    protected ClientToServerMenuPacket(Class<Menu> menuClass, int containerID) {
        this.containerID = containerID;
        this.menuClass = menuClass;
    }

    protected ClientToServerMenuPacket(Class<Menu> menuClass, FriendlyByteBuf buf) {
        this.containerID = buf.readInt();
        this.menuClass = menuClass;
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.writeInt(this.containerID);
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        AbstractContainerMenu menu;
        if (context.getSender() != null && (menu = context.getSender().f_36096_) != null) {
            return menu.f_38840_ == this.containerID && this.menuClass.isAssignableFrom(menu.getClass());
        }
        return false;
    }

    protected Menu getMenu(NetworkEvent.Context context) {
        return (Menu)((AbstractContainerMenu)this.menuClass.cast(context.getSender().f_36096_));
    }

    protected void handleWrongPlayer(NetworkEvent.Context context) {
    }

    public static class Handler<MSG extends ClientToServerMenuPacket<?>>
    extends Packet.PacketHandler<MSG> {
        private final Function<FriendlyByteBuf, MSG> constructor;

        public Handler(Function<FriendlyByteBuf, MSG> constructor) {
            this.constructor = constructor;
        }

        @Override
        public MSG fromNetwork(FriendlyByteBuf buf) {
            return (MSG)((ClientToServerMenuPacket)this.constructor.apply(buf));
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }

        @Override
        public void toNetwork(MSG packet, FriendlyByteBuf buf) {
            ((ClientToServerMenuPacket)packet).write(buf);
        }
    }
}

