/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.network;

import com.enderio.api.misc.ColorControl;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.common.redstone.RedstoneCountFilter;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record CountFilterPacket(ColorControl channel, int maxCount, int count, boolean active) implements Packet
{
    public CountFilterPacket(FriendlyByteBuf buf) {
        this((ColorControl)buf.m_130066_(ColorControl.class), buf.readInt(), buf.readInt(), buf.readBoolean());
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getSender() != null;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack mainHandItem = context.getSender().m_21205_();
        mainHandItem.getCapability(EIOCapabilities.FILTER).ifPresent(filter -> {
            if (filter instanceof RedstoneCountFilter) {
                RedstoneCountFilter countFilter = (RedstoneCountFilter)filter;
                countFilter.setState(this);
            }
        });
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130068_((Enum)this.channel);
        writeInto.writeInt(this.maxCount);
        writeInto.writeInt(this.count);
        writeInto.writeBoolean(this.active);
    }

    public static class Handler
    extends Packet.PacketHandler<CountFilterPacket> {
        @Override
        public CountFilterPacket fromNetwork(FriendlyByteBuf buf) {
            return new CountFilterPacket(buf);
        }

        @Override
        public void toNetwork(CountFilterPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

