/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.menu;

import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.common.init.ConduitMenus;
import com.enderio.conduits.common.network.TimerFilterPacket;
import com.enderio.conduits.common.redstone.RedstoneTimerFilter;
import com.enderio.core.common.network.CoreNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class RedstoneTimerFilterMenu
extends AbstractContainerMenu {
    private final ItemStack stack;
    private final RedstoneTimerFilter filter;

    protected RedstoneTimerFilterMenu(@Nullable MenuType<?> pMenuType, int pContainerId, Inventory inventory, ItemStack pStack) {
        super(pMenuType, pContainerId);
        this.stack = pStack;
        LazyOptional resourceFilter = this.stack.getCapability(EIOCapabilities.FILTER);
        this.filter = (RedstoneTimerFilter)resourceFilter.map(filter -> {
            if (filter instanceof RedstoneTimerFilter) {
                RedstoneTimerFilter cap = (RedstoneTimerFilter)filter;
                return cap;
            }
            throw new IllegalArgumentException();
        }).orElseThrow(IllegalArgumentException::new);
        this.addInventorySlots(14, 119, inventory);
    }

    protected RedstoneTimerFilterMenu(int pContainerId, Inventory inventory, ItemStack pStack) {
        this((MenuType)ConduitMenus.REDSTONE_TIMER_FILTER.get(), pContainerId, inventory, pStack);
    }

    public static RedstoneTimerFilterMenu factory(@Nullable MenuType<RedstoneTimerFilterMenu> pMenuType, int i, Inventory inventory, FriendlyByteBuf byteBuf) {
        return new RedstoneTimerFilterMenu(i, inventory, inventory.f_35978_.m_21205_());
    }

    public RedstoneTimerFilter getFilter() {
        return this.filter;
    }

    public void setTimer(String timer) {
        try {
            this.filter.setMaxTicks(Integer.parseInt(timer));
            CoreNetwork.sendToServer(new TimerFilterPacket(this.filter.getTicks(), this.filter.getMaxTicks()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        return pPlayer.m_21120_(InteractionHand.MAIN_HAND).equals(this.stack);
    }

    public void addInventorySlots(int xPos, int yPos, Inventory inventory) {
        for (int x = 0; x < 9; ++x) {
            Slot ref = new Slot((Container)inventory, x, xPos + x * 18, yPos + 58);
            this.m_38897_(ref);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot ref = new Slot((Container)inventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18);
                this.m_38897_(ref);
            }
        }
    }
}

