/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.refinedstorage;

import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.conduits.common.integrations.refinedstorage.RSNetworkNode;
import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.RSAPIInject;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.api.util.Action;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class RSNodeHost
implements ConduitData<RSNodeHost>,
INetworkNodeProxy<RSNetworkNode> {
    @RSAPIInject
    public static IRSAPI RSAPI;
    private final RSNetworkNode node;
    private final LazyOptional<RSNodeHost> selfCap = LazyOptional.of(() -> this);
    private final Level level;
    private final BlockPos pos;

    public RSNodeHost(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
        this.node = new RSNetworkNode(level, pos);
    }

    @NotNull
    public RSNetworkNode getNode() {
        if (this.level.m_5776_()) {
            return this.node;
        }
        INetworkNodeManager manager = RSAPI.getNetworkNodeManager((ServerLevel)this.level);
        INetworkNode networkNode = manager.getNode(this.pos);
        if (networkNode == null || !networkNode.getId().equals((Object)RSNetworkNode.ID)) {
            manager.setNode(this.pos, (INetworkNode)this.node);
            manager.markForSaving();
        }
        return this.node;
    }

    public LazyOptional<RSNodeHost> getSelfCap() {
        return this.selfCap;
    }

    @Override
    public void onRemoved(ConduitType<?> type, Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return;
        }
        this.selfCap.invalidate();
        INetworkNodeManager manager = RSAPI.getNetworkNodeManager((ServerLevel)level);
        INetworkNode node = manager.getNode(pos);
        manager.removeNode(pos);
        manager.markForSaving();
        if (node != null && node.getNetwork() != null) {
            node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().getLevel(), node.getNetwork().getPosition());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.node.write(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.node.read(nbt);
    }
}

