/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.data.recipe;

import com.enderio.core.common.recipes.CountedIngredient;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeDataUtil {
    public static Set<String> getIngredientsModIds(List<Ingredient> ingredients) {
        HashSet<String> mods = new HashSet<String>();
        for (Ingredient ingredient : ingredients) {
            RecipeDataUtil.putIngredientModIds(mods, ingredient);
        }
        return mods;
    }

    public static Set<String> getCountedIngredientsModIds(List<CountedIngredient> ingredients) {
        HashSet<String> mods = new HashSet<String>();
        for (CountedIngredient ingredient : ingredients) {
            RecipeDataUtil.putIngredientModIds(mods, ingredient.ingredient());
        }
        return mods;
    }

    public static Set<String> getIngredientModIds(Ingredient ingredient) {
        HashSet<String> mods = new HashSet<String>();
        RecipeDataUtil.putIngredientModIds(mods, ingredient);
        return mods;
    }

    public static Set<String> getCountedIngredientModIds(CountedIngredient ingredient) {
        HashSet<String> mods = new HashSet<String>();
        RecipeDataUtil.putIngredientModIds(mods, ingredient.ingredient());
        return mods;
    }

    private static void putIngredientModIds(Set<String> mods, Ingredient ingredient) {
        for (Ingredient.Value value : ingredient.f_43902_) {
            if (!(value instanceof Ingredient.ItemValue)) continue;
            Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
            itemValue.m_6223_().forEach(item -> {
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
                if (itemId != null) {
                    mods.add(itemId.m_135827_());
                }
            });
        }
    }
}

