/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.network;

import codechicken.lib.data.MCByteStream;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.LazyValuePair;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartNetwork;
import codechicken.multipart.util.ControlKeyModifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;

public class MultiPartSPH
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayer sender, ServerGamePacketListenerImpl handler) {
        switch (packet.getType()) {
            case 1: {
                ControlKeyModifier.setIsControlDown((Player)sender, packet.readBoolean());
            }
        }
    }

    public static void sendDescUpdate(TileMultipart tile) {
        ServerLevel world = (ServerLevel)tile.m_58904_();
        List players = world.m_7726_().f_8325_.m_183262_(new ChunkPos(tile.m_58899_()), false);
        MultiPartSPH.sendDescUpdates(players, Collections.singleton(tile));
    }

    public static void sendDescUpdates(List<ServerPlayer> players, Collection<BlockEntity> tiles) {
        if (tiles.isEmpty()) {
            return;
        }
        LinkedList<Pair<TileMultipart, MCByteStream>> data = new LinkedList<Pair<TileMultipart, MCByteStream>>();
        for (BlockEntity tile : tiles) {
            if (!(tile instanceof TileMultipart)) continue;
            TileMultipart partTile = (TileMultipart)tile;
            data.add((Pair<TileMultipart, MCByteStream>)LazyValuePair.of((Object)((Object)partTile), t -> {
                MCByteStream stream = new MCByteStream();
                t.writeDesc((MCDataOutput)stream);
                return stream;
            }));
        }
        if (data.isEmpty()) {
            return;
        }
        for (ServerPlayer player : players) {
            MultiPartSPH.sendDescUpdateTo(player, data);
        }
    }

    private static void sendDescUpdateTo(ServerPlayer player, List<Pair<TileMultipart, MCByteStream>> data) {
        PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 1);
        packet.writeVarInt(data.size());
        for (Pair<TileMultipart, MCByteStream> entry : data) {
            packet.writePos(((TileMultipart)((Object)entry.getLeft())).m_58899_());
            packet.append(((MCByteStream)entry.getRight()).getBytes());
        }
        packet.sendToPlayer(player);
    }

    public static void sendAddPart(TileMultipart tile, MultiPart part) {
        ServerLevel world = (ServerLevel)tile.m_58904_();
        MCByteStream stream = new MCByteStream();
        MultiPartRegistries.writePart((MCDataOutput)stream, part);
        world.m_7726_().f_8325_.m_183262_(new ChunkPos(tile.m_58899_()), false).forEach(player -> {
            PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 2);
            packet.writePos(tile.m_58899_());
            packet.append(stream.getBytes());
            packet.sendToPlayer(player);
        });
    }

    public static void sendRemPart(TileMultipart tile, int partIdx) {
        ServerLevel world = (ServerLevel)tile.m_58904_();
        world.m_7726_().f_8325_.m_183262_(new ChunkPos(tile.m_58899_()), false).forEach(player -> {
            PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 3);
            packet.writeByte(partIdx);
            packet.writePos(tile.m_58899_());
            packet.sendToPlayer(player);
        });
    }

    public static void dispatchPartUpdate(MultiPart part, Consumer<MCDataOutput> func) {
        ServerLevel world = (ServerLevel)part.level();
        MCByteStream stream = new MCByteStream();
        func.accept((MCDataOutput)stream);
        BlockPos pos = part.pos();
        world.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).forEach(player -> {
            PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 4);
            packet.writeByte(part.tile().getPartList().indexOf(part));
            packet.writePos(part.pos());
            packet.append(stream.getBytes());
            packet.sendToPlayer(player);
        });
    }
}

