/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part.edge;

import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.AxisCycle;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.part.StandardMicroblockPart;
import codechicken.multipart.api.part.EdgePart;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EdgeMicroblockPart
extends StandardMicroblockPart
implements EdgePart {
    public static final Cuboid6[] aBounds = new Cuboid6[256];
    public static final VoxelShape[] aShapes = new VoxelShape[256];

    public EdgeMicroblockPart(MicroMaterial material) {
        super(material);
    }

    @Override
    public void setShape(int size, int slot) {
        this.shape = (byte)(size << 4 | slot - 15);
    }

    @Override
    public Cuboid6 getBounds() {
        return aBounds[this.shape];
    }

    @Override
    public VoxelShape getShape(CollisionContext context) {
        return aShapes[this.shape];
    }

    @Override
    public StandardMicroFactory getMicroFactory() {
        return (StandardMicroFactory)CBMicroblockModContent.EDGE_MICROBLOCK_PART.get();
    }

    @Override
    public int getSlot() {
        return this.getShapeSlot() + 15;
    }

    static {
        for (int s = 0; s < 12; ++s) {
            int rx = (s & 2) != 0 ? -1 : 1;
            int rz = (s & 1) != 0 ? -1 : 1;
            Transformation tr = new TransformationList(new Transformation[]{new Scale((double)rx, 1.0, (double)rz), AxisCycle.cycles[s >> 2]}).at(Vector3.CENTER);
            for (int t = 1; t < 8; ++t) {
                double d = (double)t / 8.0;
                int i = t << 4 | s;
                EdgeMicroblockPart.aBounds[i] = new Cuboid6(0.0, 0.0, 0.0, d, 1.0, d).apply(tr);
                EdgeMicroblockPart.aShapes[i] = VoxelShapeCache.getShape((Cuboid6)aBounds[i]);
            }
        }
    }
}

