/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Cuboid6;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.part.IMicroOcclusion;
import codechicken.microblock.part.IMicroShrinkRender;
import codechicken.microblock.part.MicroblockPart;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.util.MaskedCuboid;
import codechicken.microblock.util.MicroOcclusionHelper;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.PartialOcclusionPart;
import codechicken.multipart.util.PartMap;
import java.util.List;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class StandardMicroblockPart
extends MicroblockPart
implements IMicroOcclusion,
PartialOcclusionPart,
IMicroShrinkRender {
    @Nullable
    public Cuboid6 renderBounds = null;
    public int renderMask;

    public StandardMicroblockPart(MicroMaterial material) {
        super(material);
    }

    @Override
    public abstract StandardMicroFactory getMicroFactory();

    @Override
    public int getItemFactoryId() {
        return this.getMicroFactory().factoryId;
    }

    @Override
    public int getSlot() {
        return this.getShapeSlot();
    }

    @Override
    public int getSlotMask() {
        return 1 << this.getSlot();
    }

    @Override
    public VoxelShape getPartialOcclusionShape() {
        return this.getShape(CollisionContext.m_82749_());
    }

    @Override
    public boolean occlusionTest(MultiPart npart) {
        if (!super.occlusionTest(npart)) {
            return false;
        }
        if (!(npart instanceof IMicroOcclusion)) {
            return true;
        }
        IMicroOcclusion mpart = (IMicroOcclusion)npart;
        int shape1 = MicroOcclusionHelper.shapePriority(this.getSlot());
        int shape2 = MicroOcclusionHelper.shapePriority(mpart.getSlot());
        if (mpart.getSize() + this.getSize() > 8) {
            if (shape1 == 2 && shape2 == 2 && mpart.getSlot() == (this.getSlot() ^ 1)) {
                return false;
            }
            if (mpart.getMaterial() != this.getMaterial()) {
                int e2;
                int e1;
                int axisMask;
                if (shape1 == 1 && shape2 == 1 && ((axisMask = this.getSlot() - 7 ^ mpart.getSlot() - 7) == 3 || axisMask == 5 || axisMask == 6)) {
                    return false;
                }
                if (shape1 == 0 && shape2 == 1 && !StandardMicroblockPart.edgeCornerOcclusionTest(this, mpart)) {
                    return false;
                }
                if (shape1 == 1 && shape2 == 0 && !StandardMicroblockPart.edgeCornerOcclusionTest(mpart, this)) {
                    return false;
                }
                if (shape1 == 0 && shape2 == 0 && ((e1 = this.getSlot() - 15) & 0xC) == ((e2 = mpart.getSlot() - 15) & 0xC) && (e1 & 3 ^ e2 & 3) == 3) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean edgeCornerOcclusionTest(IMicroOcclusion edge, IMicroOcclusion corner) {
        return (corner.getSlot() - 7 & PartMap.edgeAxisMask(edge.getSlot() - 15)) == PartMap.unpackEdgeBits(edge.getSlot() - 15);
    }

    @Override
    public Iterable<MaskedCuboid> getRenderCuboids(boolean isInventory) {
        if (isInventory) {
            return List.of(new MaskedCuboid(this.getBounds(), 0));
        }
        return List.of(new MaskedCuboid(this.renderBounds, this.renderMask));
    }

    @Override
    public void onPartChanged(@Nullable MultiPart part) {
        super.onPartChanged(part);
        if (this.level().f_46443_) {
            this.recalcBounds();
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (this.level().f_46443_) {
            this.recalcBounds();
        }
    }

    @Override
    public void readUpdate(MCDataInput packet) {
        super.readUpdate(packet);
        if (this.level().f_46443_) {
            this.recalcBounds();
        }
    }

    public void recalcBounds() {
        this.renderBounds = this.getBounds().copy();
        this.renderMask = MicroOcclusionHelper.recalcBounds(this, this.renderBounds);
    }

    @Override
    public int getPriorityClass() {
        return 0;
    }
}

