/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.client;

import codechicken.microblock.api.MicroHighlightRenderer;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.part.StandardMicroFactory;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

public class MicroMaterialClientRegistry {
    private static final Map<MicroMaterial, List<MicroHighlightRenderer>> SPECIFIC_HIGHLIGHT_RENDERERS = new HashMap<MicroMaterial, List<MicroHighlightRenderer>>();
    private static final List<MicroHighlightRenderer> GLOBAL_HIGHLIGHT_RENDERERS = new LinkedList<MicroHighlightRenderer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHighlightRenderer(MicroMaterial material, MicroHighlightRenderer renderer) {
        Map<MicroMaterial, List<MicroHighlightRenderer>> map = SPECIFIC_HIGHLIGHT_RENDERERS;
        synchronized (map) {
            SPECIFIC_HIGHLIGHT_RENDERERS.computeIfAbsent(material, e -> new LinkedList()).add(renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalHighlightRenderer(MicroHighlightRenderer renderer) {
        List<MicroHighlightRenderer> list = GLOBAL_HIGHLIGHT_RENDERERS;
        synchronized (list) {
            GLOBAL_HIGHLIGHT_RENDERERS.add(renderer);
        }
    }

    public static boolean renderHighlightOverride(Player player, InteractionHand hand, BlockHitResult hit, StandardMicroFactory factory, int size, MicroMaterial material, PoseStack pStack, MultiBufferSource buffers, float partialTicks) {
        List specific = SPECIFIC_HIGHLIGHT_RENDERERS.getOrDefault(material, List.of());
        for (MicroHighlightRenderer renderer : specific) {
            if (!renderer.renderHighlight(player, hand, hit, factory, size, material, pStack, buffers, partialTicks)) continue;
            return true;
        }
        for (MicroHighlightRenderer renderer : GLOBAL_HIGHLIGHT_RENDERERS) {
            if (!renderer.renderHighlight(player, hand, hit, factory, size, material, pStack, buffers, partialTicks)) continue;
            return true;
        }
        return false;
    }
}

