/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm.transformers;

import codechicken.asm.ASMHelper;
import codechicken.asm.ObfMapping;
import codechicken.asm.transformers.ClassNodeTransformer;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class MethodTransformer
extends ClassNodeTransformer {
    public final ObfMapping method;

    public MethodTransformer(ObfMapping method) {
        this.method = method;
    }

    @Override
    public String className() {
        return this.method.javaClass();
    }

    @Override
    public void transform(ClassNode cnode) {
        MethodNode mv = ASMHelper.findMethod(this.method, cnode);
        if (mv == null) {
            throw new RuntimeException("Method not found: " + this.method);
        }
        try {
            this.transform(mv);
        }
        catch (Exception e) {
            throw new RuntimeException("Error transforming method: " + this.method, e);
        }
    }

    public abstract void transform(MethodNode var1);
}

